/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.util.Strings;

public class AttributeValueAssertion {
    private String attributeDesc;
    private byte[] assertion;

    public static String dumpObject(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof byte[]) {
                return Strings.dumpBytes((byte[])object);
            }
            if (object instanceof Value) {
                return ((Value)object).getValue();
            }
            return "<unknown type>";
        }
        return "";
    }

    public String getAttributeDesc() {
        return this.attributeDesc;
    }

    public void setAttributeDesc(String attributeDesc) {
        this.attributeDesc = attributeDesc;
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("AttributeValueAssertion\n");
        sb.append(tabs).append("    Assertion description : '");
        sb.append(this.attributeDesc != null ? this.attributeDesc : "null");
        sb.append("'\n");
        sb.append(tabs).append("    Assertion value : '").append(AttributeValueAssertion.dumpObject(this.assertion)).append("'\n");
        return sb.toString();
    }

    public String toStringRFC2254(int filterType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attributeDesc);
        switch (filterType) {
            case 0: {
                sb.append('=');
                break;
            }
            case 2: {
                sb.append("<=");
                break;
            }
            case 1: {
                sb.append(">=");
                break;
            }
            case 3: {
                sb.append("~=");
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_05503_UNEXPECTED_FILTER_TYPE, filterType));
            }
        }
        sb.append(AttributeValueAssertion.dumpObject(this.assertion));
        return sb.toString();
    }

    public byte[] getAssertion() {
        return this.assertion;
    }

    public void setAssertion(byte[] assertion) {
        if (assertion != null) {
            this.assertion = new byte[assertion.length];
            System.arraycopy(assertion, 0, this.assertion, 0, assertion.length);
        }
    }

    public String toString() {
        return this.toString("");
    }
}

