/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.SingleBaseSearch;

public class DirectoryPrincipalStore
implements PrincipalStore {
    private final DirectoryService directoryService;
    private final Dn searchBaseDn;

    public DirectoryPrincipalStore(DirectoryService directoryService, Dn searchBaseDn) {
        this.directoryService = directoryService;
        this.searchBaseDn = searchBaseDn;
    }

    @Override
    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        SingleBaseSearch singleBaseSearch = new SingleBaseSearch(this.directoryService, this.searchBaseDn);
        return singleBaseSearch.changePassword(principal, newPassword);
    }

    @Override
    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        SingleBaseSearch singleBaseSearch = new SingleBaseSearch(this.directoryService, this.searchBaseDn);
        return singleBaseSearch.getPrincipal(principal);
    }
}

