/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.entryChange;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeContainer;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.EntryChange;
import org.apache.directory.api.ldap.model.message.controls.EntryChangeImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryChangeDecorator
extends ControlDecorator<EntryChange>
implements EntryChange {
    public static final int UNDEFINED_CHANGE_NUMBER = -1;
    private byte[] previousDnBytes = null;
    private int eccSeqLength;
    private static final Asn1Decoder decoder = new Asn1Decoder();

    public EntryChangeDecorator(LdapApiService codec) {
        super(codec, new EntryChangeImpl());
    }

    public EntryChangeDecorator(LdapApiService codec, EntryChange control) {
        super(codec, control);
    }

    private EntryChange getEntryChange() {
        return (EntryChange)this.getDecorated();
    }

    @Override
    public int computeLength() {
        int changeTypesLength = 3;
        int previousDnLength = 0;
        int changeNumberLength = 0;
        if (this.getPreviousDn() != null) {
            this.previousDnBytes = Strings.getBytesUtf8(this.getPreviousDn().getName());
            previousDnLength = 1 + TLV.getNbBytes(this.previousDnBytes.length) + this.previousDnBytes.length;
        }
        if (this.getChangeNumber() != -1L) {
            changeNumberLength = 2 + BerValue.getNbBytes(this.getChangeNumber());
        }
        this.eccSeqLength = changeTypesLength + previousDnLength + changeNumberLength;
        this.valueLength = 1 + TLV.getNbBytes(this.eccSeqLength) + this.eccSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.eccSeqLength));
        buffer.put(UniversalTag.ENUMERATED.getValue());
        buffer.put((byte)1);
        buffer.put(BerValue.getBytes(this.getChangeType().getValue()));
        if (this.getPreviousDn() != null) {
            BerValue.encode(buffer, this.previousDnBytes);
        }
        if (this.getChangeNumber() != -1L) {
            BerValue.encode(buffer, this.getChangeNumber());
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(this.eccSeqLength));
                buffer.put(UniversalTag.ENUMERATED.getValue());
                buffer.put((byte)1);
                buffer.put(BerValue.getBytes(this.getChangeType().getValue()));
                if (this.getPreviousDn() != null) {
                    BerValue.encode(buffer, this.previousDnBytes);
                }
                if (this.getChangeNumber() != -1L) {
                    BerValue.encode(buffer, this.getChangeNumber());
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public ChangeType getChangeType() {
        return this.getEntryChange().getChangeType();
    }

    @Override
    public void setChangeType(ChangeType changeType) {
        this.getEntryChange().setChangeType(changeType);
    }

    @Override
    public Dn getPreviousDn() {
        return this.getEntryChange().getPreviousDn();
    }

    @Override
    public void setPreviousDn(Dn previousDn) {
        this.getEntryChange().setPreviousDn(previousDn);
    }

    @Override
    public long getChangeNumber() {
        return this.getEntryChange().getChangeNumber();
    }

    @Override
    public void setChangeNumber(long changeNumber) {
        this.getEntryChange().setChangeNumber(changeNumber);
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        EntryChangeContainer container = new EntryChangeContainer(this.getCodecService(), this);
        decoder.decode(bb, container);
        return this;
    }
}

