/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.search.subentries;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesContainer;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesStates;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubentriesGrammar
extends AbstractGrammar<SubentriesContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SubentriesGrammar.class);
    private static Grammar<SubentriesContainer> instance = new SubentriesGrammar();

    private SubentriesGrammar() {
        this.setName(SubentriesGrammar.class.getName());
        this.transitions = new GrammarTransition[SubentriesStates.LAST_SUB_ENTRY_STATE.ordinal()][256];
        this.transitions[SubentriesStates.START_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SubentriesContainer>(SubentriesStates.START_STATE, SubentriesStates.SUB_ENTRY_VISIBILITY_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SubentriesContainer>("SubEntryControl visibility"){

            @Override
            public void action(SubentriesContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                BerValue value = tlv.getValue();
                try {
                    container.getSubentriesControl().setVisibility(BooleanDecoder.parse(value));
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    LOG.error(I18n.err(I18n.ERR_04054, Strings.dumpBytes(value.getData()), bde.getMessage()));
                    throw new DecoderException(bde.getMessage());
                }
            }
        });
    }

    public static Grammar<SubentriesContainer> getInstance() {
        return instance;
    }
}

