/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.util.Strings;

public class KerberosTime
implements Comparable<KerberosTime>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private String date;
    private long kerberosTime;
    public static final KerberosTime INFINITY = new KerberosTime(Long.MAX_VALUE);
    public static final int MINUTE = 60000;
    public static final int DAY = 86400000;
    public static final int WEEK = 604800000;

    public KerberosTime() {
        this.kerberosTime = System.currentTimeMillis() / 1000L * 1000L;
        this.convertInternal(this.kerberosTime);
    }

    public KerberosTime(String date) {
        try {
            this.setDate(date);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Bad time : " + date);
        }
    }

    public KerberosTime(long date) {
        this.convertInternal(date);
    }

    public KerberosTime(Date time) {
        this.kerberosTime = time.getTime() / 1000L * 1000L;
        this.convertInternal(this.kerberosTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertInternal(long date) {
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTimeInMillis(date);
        SimpleDateFormat simpleDateFormat = KerberosUtils.UTC_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            this.date = KerberosUtils.UTC_DATE_FORMAT.format(calendar.getTime());
        }
        this.kerberosTime = calendar.getTimeInMillis() / 1000L * 1000L;
    }

    public long getTime() {
        return this.kerberosTime;
    }

    public Date toDate() {
        return new Date(this.kerberosTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KerberosTime getTime(String zuluTime) throws ParseException {
        Date date = null;
        SimpleDateFormat simpleDateFormat = KerberosUtils.UTC_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            date = KerberosUtils.UTC_DATE_FORMAT.parse(zuluTime);
        }
        return new KerberosTime(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = KerberosUtils.UTC_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            this.kerberosTime = KerberosUtils.UTC_DATE_FORMAT.parse(date).getTime();
        }
        this.convertInternal(this.kerberosTime);
    }

    public byte[] getBytes() {
        return Strings.getBytesUtf8(this.date);
    }

    public String getDate() {
        return this.date;
    }

    public int hashCode() {
        return (int)this.kerberosTime;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return true;
        }
        KerberosTime other = (KerberosTime)obj;
        return this.kerberosTime == other.kerberosTime;
    }

    public boolean isInClockSkew(long clockSkew) {
        long delta = Math.abs(this.kerberosTime - System.currentTimeMillis());
        return delta < clockSkew;
    }

    @Override
    public int compareTo(KerberosTime that) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == that) {
            return 0;
        }
        if (this.kerberosTime < that.kerberosTime) {
            return -1;
        }
        if (this.kerberosTime > that.kerberosTime) {
            return 1;
        }
        return 0;
    }

    public boolean lessThan(KerberosTime ktime) {
        return this.kerberosTime <= ktime.kerberosTime;
    }

    public boolean greaterThan(KerberosTime ktime) {
        return this.kerberosTime > ktime.kerberosTime;
    }

    public boolean isZero() {
        return this.kerberosTime == 0L;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.date);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String date = in.readUTF();
        try {
            this.setDate(date);
        }
        catch (ParseException pe) {
            this.kerberosTime = System.currentTimeMillis() / 1000L * 1000L;
            this.convertInternal(this.kerberosTime);
        }
    }

    public String toString() {
        return this.date;
    }
}

