/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ScopeNode;
import org.apache.directory.shared.ldap.model.message.SearchScope;

public class OneLevelScopeEvaluator<E>
implements Evaluator<ScopeNode> {
    private final ScopeNode node;
    private final String baseId;
    private final boolean dereferencing;
    private final Store db;

    public OneLevelScopeEvaluator(Store db, ScopeNode node) throws Exception {
        this.node = node;
        if (node.getScope() != SearchScope.ONELEVEL) {
            throw new IllegalStateException(I18n.err(I18n.ERR_720, new Object[0]));
        }
        this.db = db;
        this.baseId = node.getBaseId();
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    @Override
    public boolean evaluate(Entry candidate) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_721, new Object[0]));
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> candidate) throws Exception {
        ParentIdAndRdn parent = this.db.getRdnIndex().reverseLookup(candidate.getId());
        boolean isChild = parent.getParentId().equals(this.baseId);
        if (!this.dereferencing) {
            return isChild;
        }
        if (null != this.db.getAliasIndex().reverseLookup(candidate.getId())) {
            return false;
        }
        if (isChild) {
            return true;
        }
        return this.db.getOneAliasIndex().forward(this.baseId, candidate.getId());
    }

    @Override
    public ScopeNode getExpression() {
        return this.node;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("OneLevelScopEvaluator : ").append(this.node).append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

