/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;

public class NotEvaluator
implements Evaluator<NotNode> {
    private final NotNode node;
    private final Evaluator<? extends ExprNode> childEvaluator;

    public NotEvaluator(NotNode node, Evaluator<? extends ExprNode> childEvaluator) {
        this.node = node;
        this.childEvaluator = childEvaluator;
    }

    @Override
    public boolean evaluate(Entry entry) throws Exception {
        return !this.childEvaluator.evaluate(entry);
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> indexEntry) throws Exception {
        return !this.childEvaluator.evaluate(indexEntry);
    }

    @Override
    public NotNode getExpression() {
        return this.node;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("NotEvaluator : ").append(this.node).append('\n');
        sb.append(this.childEvaluator.toString(tabs + "  "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

