/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.log.impl;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.log.InvalidLogException;
import org.apache.directory.server.log.LogAnchor;
import org.apache.directory.server.log.LogScanner;
import org.apache.directory.server.log.UserLogRecord;
import org.apache.directory.server.log.impl.LogFileManager;
import org.apache.directory.server.log.impl.LogFileRecords;

public class DefaultLogScanner
implements LogScanner {
    private long prevLSN = Long.MIN_VALUE;
    private long prevLogFileNumber = -1L;
    private long prevLogFileOffset = -1L;
    private LogAnchor startingLogAnchor = new LogAnchor();
    private long lastReadLSN = Long.MIN_VALUE;
    LogFileManager.LogFileReader currentLogFile;
    boolean closed = false;
    boolean invalidLog = false;
    LogFileManager logFileManager;
    byte[] markerBuffer = new byte[LogFileRecords.MAX_MARKER_SIZE];
    ByteBuffer markerHead = ByteBuffer.wrap(this.markerBuffer);

    public DefaultLogScanner(LogAnchor startingLogAnchor, LogFileManager logFileManger) {
        startingLogAnchor.resetLogAnchor(startingLogAnchor);
        this.logFileManager = this.logFileManager;
    }

    @Override
    public boolean getNextRecord(UserLogRecord logRecord) throws IOException, InvalidLogException {
        boolean startingRead = false;
        this.checkIfClosed();
        if (this.invalidLog) {
            throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
        }
        try {
            long startingLSN;
            long fileOffset;
            block10: {
                if (this.currentLogFile == null) {
                    long startingOffset = this.startingLogAnchor.getLogFileOffset();
                    this.currentLogFile = this.readFileHeader(this.startingLogAnchor.getLogFileNumber());
                    if (this.currentLogFile == null) {
                        return false;
                    }
                    if (startingOffset > 0L) {
                        if (startingOffset < 12L) {
                            this.markScanInvalid();
                        }
                        this.prevLogFileOffset = Math.max(startingOffset, this.currentLogFile.getLength());
                        this.currentLogFile.seek(startingOffset);
                    }
                    startingRead = true;
                }
                while (true) {
                    long fileLength = this.currentLogFile.getLength();
                    fileOffset = this.currentLogFile.getOffset();
                    if (fileOffset > fileLength) {
                        this.markScanInvalid();
                        continue;
                    }
                    if (fileOffset != fileLength) break block10;
                    long nextLogFileNumber = this.currentLogFile.logFileNumber() + 1L;
                    this.currentLogFile.close();
                    this.currentLogFile = this.readFileHeader(nextLogFileNumber);
                    if (this.currentLogFile == null) break;
                }
                return false;
            }
            int recordLength = this.readRecordHeader();
            if (startingRead && (startingLSN = this.startingLogAnchor.getLogLSN()) != Long.MIN_VALUE && startingLSN != this.lastReadLSN) {
                this.markScanInvalid();
            }
            this.readLogRecord(logRecord, recordLength);
            this.readRecordFooter();
            fileOffset = this.currentLogFile.getOffset();
            LogAnchor userLogAnchor = logRecord.getLogAnchor();
            userLogAnchor.resetLogAnchor(this.currentLogFile.logFileNumber(), fileOffset - (long)recordLength, this.lastReadLSN);
            this.prevLogFileOffset = fileOffset;
            this.prevLogFileNumber = this.currentLogFile.logFileNumber();
            this.prevLSN = this.lastReadLSN;
        }
        catch (EOFException e) {
            this.markScanInvalid();
        }
        return true;
    }

    @Override
    public long getLastGoodFileNumber() {
        return this.prevLogFileNumber;
    }

    @Override
    public long getLastGoodOffset() {
        return this.prevLogFileOffset;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.currentLogFile != null) {
                try {
                    this.currentLogFile.close();
                    this.currentLogFile = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private int readRecordHeader() throws IOException, InvalidLogException, EOFException {
        boolean invalid = false;
        this.markerHead.rewind();
        this.currentLogFile.read(this.markerBuffer, 0, 24);
        int magicNumber = this.markerHead.getInt();
        int length = this.markerHead.getInt();
        long lsn = this.markerHead.getLong();
        long checksum = this.markerHead.getLong();
        if (magicNumber != 0x10F010F) {
            invalid = true;
        }
        if (length <= 32) {
            invalid = true;
        }
        if (lsn < this.prevLSN) {
            invalid = true;
        }
        if (checksum != (lsn ^ (long)length)) {
            invalid = true;
        }
        if (invalid) {
            this.markScanInvalid();
        }
        this.lastReadLSN = lsn;
        return length;
    }

    private void readRecordFooter() throws IOException, InvalidLogException, EOFException {
        boolean invalid = false;
        this.markerHead.rewind();
        this.currentLogFile.read(this.markerBuffer, 0, 8);
        int checksum = this.markerHead.getInt();
        int magicNumber = this.markerHead.getInt();
        if (magicNumber != 0xF010F01) {
            invalid = true;
        }
        if (invalid) {
            this.markScanInvalid();
        }
    }

    private void readLogRecord(UserLogRecord userRecord, int length) throws IOException, EOFException {
        byte[] dataBuffer = userRecord.getDataBuffer();
        if (dataBuffer == null || dataBuffer.length < length) {
            dataBuffer = new byte[length];
        }
        this.currentLogFile.read(dataBuffer, 0, length);
        userRecord.setData(dataBuffer, length);
    }

    private LogFileManager.LogFileReader readFileHeader(long logFileNumber) throws IOException, InvalidLogException, EOFException {
        LogFileManager.LogFileReader logFile;
        boolean invalid = false;
        try {
            logFile = this.logFileManager.getReaderForLogFile(logFileNumber);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        this.prevLogFileNumber = logFileNumber;
        this.prevLogFileOffset = 0L;
        this.markerHead.rewind();
        this.currentLogFile.read(this.markerBuffer, 0, 12);
        long persistedLogFileNumber = this.markerHead.getLong();
        int magicNumber = this.markerHead.getInt();
        if (persistedLogFileNumber != logFileNumber) {
            invalid = true;
        }
        if (magicNumber != -16711936) {
            invalid = true;
        }
        if (invalid) {
            this.markScanInvalid();
        }
        this.prevLogFileOffset = 12L;
        return logFile;
    }

    private void checkIfClosed() {
        if (this.closed) {
            throw new IllegalStateException(I18n.err(I18n.ERR_749, new Object[0]));
        }
    }

    private void markScanInvalid() throws InvalidLogException {
        this.invalidLog = true;
        throw new InvalidLogException(I18n.err(I18n.ERR_750, new Object[0]));
    }
}

