/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.UsageEnum;
import org.apache.directory.shared.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationalAttributeInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(OperationalAttributeInterceptor.class);
    private final EntryFilter DENORMALIZING_SEARCH_FILTER = new OperationalAttributeDenormalizingSearchFilter();
    private final EntryFilter SEARCH_FILTER = new OperationalAttributeSearchFilter();
    private Dn subschemaSubentryDn;
    private Dn adminDn;
    private static AttributeType entryUuidAT;
    private static AttributeType entryCsnAT;
    private static AttributeType creatorsNameAT;
    private static AttributeType createTimeStampAT;
    private static AttributeType accessControlSubentriesAT;
    private static AttributeType collectiveAttributeSubentriesAT;
    private static AttributeType triggerExecutionSubentriesAT;
    private static AttributeType subschemaSubentryAT;

    public OperationalAttributeInterceptor() {
        super(InterceptorEnum.OPERATIONAL_ATTRIBUTE_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        Value<?> subschemaSubentry = directoryService.getPartitionNexus().getRootDse(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = directoryService.getDnFactory().create(subschemaSubentry.getString());
        this.adminDn = directoryService.getDnFactory().create("uid=admin,ou=system");
        entryUuidAT = this.schemaManager.getAttributeType("1.3.6.1.1.16.4");
        entryCsnAT = this.schemaManager.getAttributeType("1.3.6.1.4.1.4203.666.1.7");
        creatorsNameAT = this.schemaManager.getAttributeType("creatorsName");
        createTimeStampAT = this.schemaManager.getAttributeType("2.5.18.1");
        accessControlSubentriesAT = this.schemaManager.getAttributeType("1.3.6.1.4.1.18060.0.4.1.2.11");
        collectiveAttributeSubentriesAT = this.schemaManager.getAttributeType("2.5.18.12");
        triggerExecutionSubentriesAT = this.schemaManager.getAttributeType("triggerExecutionSubentries");
        subschemaSubentryAT = this.schemaManager.getAttributeType("subschemaSubentry");
    }

    @Override
    public void destroy() {
    }

    private boolean checkAddOperationalAttribute(boolean isAdmin, Entry entry, AttributeType attribute) throws LdapException {
        if (entry.containsAttribute(attribute)) {
            if (!isAdmin) {
                String message = I18n.err(I18n.ERR_30, attribute);
                LOG.error(message);
                throw new LdapNoPermissionException(message);
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        String principal = OperationalAttributeInterceptor.getPrincipal(addContext).getName();
        Entry entry = addContext.getEntry();
        boolean isAdmin = addContext.getSession().getAuthenticatedPrincipal().getName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        if (!this.checkAddOperationalAttribute(isAdmin, entry, entryUuidAT)) {
            entry.put(entryUuidAT, UUID.randomUUID().toString());
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, entryCsnAT)) {
            entry.put(entryCsnAT, this.directoryService.getCSN().toString());
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, creatorsNameAT)) {
            entry.put(creatorsNameAT, principal);
        }
        if (!this.checkAddOperationalAttribute(isAdmin, entry, createTimeStampAT)) {
            entry.put(createTimeStampAT, DateUtils.getGeneralizedTime());
        }
        this.checkAddOperationalAttribute(isAdmin, entry, accessControlSubentriesAT);
        this.checkAddOperationalAttribute(isAdmin, entry, collectiveAttributeSubentriesAT);
        this.checkAddOperationalAttribute(isAdmin, entry, triggerExecutionSubentriesAT);
        this.checkAddOperationalAttribute(isAdmin, entry, subschemaSubentryAT);
        this.next(addContext);
    }

    @Override
    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(listContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Entry result = this.next(lookupContext);
        if (lookupContext.hasAllUser()) {
            if (lookupContext.hasAllOperational()) {
                return result;
            }
            this.filter(lookupContext, result);
        } else if (lookupContext.hasAllOperational()) {
            this.filterUserAttributes(lookupContext, result);
        } else if (lookupContext.getAttrsId() == null || lookupContext.getAttrsId().size() == 0) {
            if (lookupContext.hasNoAttribute()) {
                result.clear();
            } else {
                this.filterOperationalAttributes(result);
            }
        } else {
            this.filterList(lookupContext, result);
        }
        this.denormalizeEntryOpAttrs(result);
        return result;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        List<Modification> mods = modifyContext.getModItems();
        boolean isAdmin = modifyContext.getSession().getAuthenticatedPrincipal().getDn().equals(this.adminDn);
        boolean modifierAtPresent = false;
        boolean modifiedTimeAtPresent = false;
        boolean entryCsnAtPresent = false;
        Dn dn = modifyContext.getDn();
        for (Modification modification : mods) {
            AttributeType attributeType = modification.getAttribute().getAttributeType();
            if (attributeType.equals(MODIFIERS_NAME_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_31, new Object[0]);
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                modifierAtPresent = true;
            }
            if (attributeType.equals(MODIFY_TIMESTAMP_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_32, new Object[0]);
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                modifiedTimeAtPresent = true;
            }
            if (attributeType.equals(ENTRY_CSN_AT)) {
                if (!isAdmin) {
                    String message = I18n.err(I18n.ERR_32, new Object[0]);
                    LOG.error(message);
                    throw new LdapNoPermissionException(message);
                }
                entryCsnAtPresent = true;
            }
            if (!PWD_POLICY_STATE_ATTRIBUTE_TYPES.contains(attributeType) || isAdmin) continue;
            String message = I18n.err(I18n.ERR_32, new Object[0]);
            LOG.error(message);
            throw new LdapNoPermissionException(message);
        }
        if (!dn.equals(this.subschemaSubentryDn)) {
            DefaultAttribute attribute;
            if (!modifierAtPresent) {
                attribute = new DefaultAttribute(MODIFIERS_NAME_AT, OperationalAttributeInterceptor.getPrincipal(modifyContext).getName());
                DefaultModification modifiersName = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
                mods.add(modifiersName);
            }
            if (!modifiedTimeAtPresent) {
                attribute = new DefaultAttribute(MODIFY_TIMESTAMP_AT, DateUtils.getGeneralizedTime());
                DefaultModification timestamp = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
                mods.add(timestamp);
            }
            if (!entryCsnAtPresent) {
                String csn = this.directoryService.getCSN().toString();
                DefaultAttribute attribute2 = new DefaultAttribute(ENTRY_CSN_AT, csn);
                DefaultModification updatedCsn = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute2);
                mods.add(updatedCsn);
            }
        }
        this.next(modifyContext);
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Entry modifiedEntry = moveContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(moveContext).getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        modifiedEntry.setDn(moveContext.getNewDn());
        moveContext.setModifiedEntry(modifiedEntry);
        this.next(moveContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry modifiedEntry = moveAndRenameContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(moveAndRenameContext).getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        modifiedEntry.setDn(moveAndRenameContext.getNewDn());
        moveAndRenameContext.setModifiedEntry(modifiedEntry);
        this.next(moveAndRenameContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        entry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(renameContext).getName());
        entry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        Entry modifiedEntry = renameContext.getOriginalEntry().clone();
        modifiedEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal(renameContext).getName());
        modifiedEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        renameContext.setModifiedEntry(modifiedEntry);
        this.next(renameContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        if (searchContext.isAllOperationalAttributes() || searchContext.getReturningAttributes() != null && !searchContext.getReturningAttributes().isEmpty()) {
            if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
                cursor.addEntryFilter(this.DENORMALIZING_SEARCH_FILTER);
            }
            return cursor;
        }
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    private boolean filterOperationalAttributes(Entry attributes) throws LdapException {
        HashSet<AttributeType> removedAttributes = new HashSet<AttributeType>();
        for (Attribute attribute : attributes.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
            removedAttributes.add(attributeType);
        }
        for (AttributeType attributeType : removedAttributes) {
            attributes.removeAttributes(attributeType);
        }
        return true;
    }

    private boolean filterUserAttributes(LookupOperationContext lookupContext, Entry attributes) throws LdapException {
        HashSet<String> removedAttributes = new HashSet<String>();
        for (Attribute attribute : attributes.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.getUsage() != UsageEnum.USER_APPLICATIONS) continue;
            removedAttributes.add(attributeType.getOid());
        }
        for (String string : lookupContext.getAttrsId()) {
            removedAttributes.remove(string);
        }
        for (String string : removedAttributes) {
            attributes.removeAttributes(string);
        }
        return true;
    }

    private void filter(LookupOperationContext lookupContext, Entry entry) throws LdapException {
        Dn dn = lookupContext.getDn();
        List<String> ids = lookupContext.getAttrsId();
        if (ids == null || ids.isEmpty()) {
            this.filterOperationalAttributes(entry);
            return;
        }
        if (dn.size() == 0) {
            HashSet<AttributeType> removedAttributes = new HashSet<AttributeType>();
            for (Attribute attribute : entry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS || ids.contains(attributeType.getOid())) continue;
                removedAttributes.add(attributeType);
            }
            for (AttributeType attributeType : removedAttributes) {
                entry.removeAttributes(attributeType);
            }
        }
        this.denormalizeEntryOpAttrs(entry);
    }

    private void filterList(LookupOperationContext lookupContext, Entry entry) throws LdapException {
        Dn dn = lookupContext.getDn();
        List<String> ids = lookupContext.getAttrsId();
        if (ids == null || ids.isEmpty()) {
            this.filterOperationalAttributes(entry);
            return;
        }
        if (dn.size() == 0) {
            HashSet<AttributeType> removedAttributes = new HashSet<AttributeType>();
            for (Attribute attribute : entry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                if (ids.contains(attributeType.getOid())) continue;
                removedAttributes.add(attributeType);
            }
            for (AttributeType attributeType : removedAttributes) {
                entry.removeAttributes(attributeType);
            }
        }
        this.denormalizeEntryOpAttrs(entry);
    }

    private void denormalizeEntryOpAttrs(Entry entry) throws LdapException {
        if (this.directoryService.isDenormalizeOpAttrsEnabled()) {
            Dn modifiersName;
            Attribute attr = entry.get("creatorsName");
            if (attr != null) {
                Dn creatorsName = this.directoryService.getDnFactory().create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(creatorsName).getName());
            }
            if ((attr = entry.get("modifiersName")) != null) {
                modifiersName = this.directoryService.getDnFactory().create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
            if ((attr = entry.get("schemaModifiersName")) != null) {
                modifiersName = this.directoryService.getDnFactory().create(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
        }
    }

    private Dn denormalizeTypes(Dn dn) throws LdapException {
        Dn newDn = new Dn(this.schemaManager);
        int size = dn.size();
        for (int pos = 0; pos < size; ++pos) {
            Rdn rdn = dn.getRdn(size - 1 - pos);
            if (rdn.size() == 0) {
                newDn = newDn.add(new Rdn());
                continue;
            }
            if (rdn.size() == 1) {
                String name = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                String value = rdn.getNormValue().getString();
                newDn = newDn.add(new Rdn(name, value));
                continue;
            }
            StringBuffer buf = new StringBuffer();
            Iterator<Ava> atavs = rdn.iterator();
            while (atavs.hasNext()) {
                Ava atav = atavs.next();
                String type = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getNormValue());
                if (!atavs.hasNext()) continue;
                buf.append('+');
            }
            newDn = newDn.add(new Rdn(buf.toString()));
        }
        return newDn;
    }

    private boolean filterDenormalized(Entry entry) throws Exception {
        this.denormalizeEntryOpAttrs(entry);
        return true;
    }

    private class OperationalAttributeSearchFilter
    implements EntryFilter {
        private OperationalAttributeSearchFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            return operation.getReturningAttributesString() != null || OperationalAttributeInterceptor.this.filterOperationalAttributes(entry);
        }
    }

    private class OperationalAttributeDenormalizingSearchFilter
    implements EntryFilter {
        private OperationalAttributeDenormalizingSearchFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            if (operation.getReturningAttributesString() == null) {
                return true;
            }
            return OperationalAttributeInterceptor.this.filterDenormalized(entry);
        }
    }
}

