/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.partition;

import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InvalidNameException;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapOtherException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;

public abstract class AbstractPartition
implements Partition {
    protected boolean initialized;
    protected SchemaManager schemaManager;
    protected String id;
    protected Dn suffixDn;

    @Override
    public void initialize() throws LdapException {
        if (this.initialized) {
            return;
        }
        try {
            this.doInit();
            this.initialized = true;
        }
        catch (Exception e) {
            throw new LdapOtherException(e.getMessage(), e);
        }
        finally {
            if (!this.initialized) {
                try {
                    this.destroy();
                }
                catch (Exception e) {
                    throw new LdapOtherException(e.getMessage(), e);
                }
            }
        }
    }

    protected abstract void doDestroy() throws Exception;

    protected abstract void doInit() throws InvalidNameException, Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() throws Exception {
        try {
            this.doDestroy();
        }
        finally {
            this.initialized = false;
        }
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public final SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.checkInitialized("id");
        this.id = id;
    }

    @Override
    public final Dn getSuffixDn() {
        return this.suffixDn;
    }

    @Override
    public void setSuffixDn(Dn suffixDn) throws LdapInvalidDnException {
        this.checkInitialized("suffixDn");
        this.suffixDn = suffixDn;
        this.suffixDn.apply(this.schemaManager);
    }

    @Override
    public void dumpIndex(OutputStream stream, String name) throws IOException {
        stream.write(Strings.getBytesUtf8("Nothing to dump for index " + name));
    }

    protected void checkInitialized(String property) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err(I18n.ERR_576, property));
        }
    }
}

