/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.GreaterEqEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreaterEqCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final String UNSUPPORTED_MSG = "GreaterEqCursors only support positioning by element when a user index exists on the asserted attribute.";
    private final GreaterEqEvaluator<V, ID> greaterEqEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<String, Entry, ID> uuidIdxCursor;
    private IndexEntry<String, ID> uuidCandidate;

    public GreaterEqCursor(Store<Entry, ID> db, GreaterEqEvaluator<V, ID> greaterEqEvaluator) throws Exception {
        LOG_CURSOR.debug("Creating GreaterEqCursor {}", this);
        this.greaterEqEvaluator = greaterEqEvaluator;
        AttributeType attributeType = greaterEqEvaluator.getExpression().getAttributeType();
        if (db.hasIndexOn(attributeType)) {
            this.userIdxCursor = db.getIndex(attributeType).forwardCursor();
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = db.getEntryUuidIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor != null) {
            if (this.greaterEqEvaluator.getComparator().compare(value, this.greaterEqEvaluator.getExpression().getValue().getValue()) <= 0) {
                this.beforeFirst();
                return;
            }
            this.userIdxCursor.beforeValue(id, value);
            this.setAvailable(false);
        } else {
            super.beforeValue(id, value);
        }
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.greaterEqEvaluator.getComparator().compare(value, this.greaterEqEvaluator.getExpression().getValue().getValue());
            if (comparedValue == 0) {
                this.userIdxCursor.afterValue(id, value);
                this.setAvailable(false);
                return;
            }
            if (comparedValue < 0) {
                this.beforeFirst();
                return;
            }
            this.userIdxCursor.afterValue(id, value);
            this.setAvailable(false);
        } else {
            super.afterValue(id, value);
        }
    }

    @Override
    public void before(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            if (this.greaterEqEvaluator.getComparator().compare(element.getKey(), this.greaterEqEvaluator.getExpression().getValue().getValue()) <= 0) {
                this.beforeFirst();
                return;
            }
            this.userIdxCursor.before((Entry)((Object)element));
            this.setAvailable(false);
        } else {
            super.before(element);
        }
    }

    @Override
    public void after(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.greaterEqEvaluator.getComparator().compare(element.getKey(), this.greaterEqEvaluator.getExpression().getValue().getValue());
            if (comparedValue == 0) {
                this.userIdxCursor.after((Entry)((Object)element));
                this.setAvailable(false);
                return;
            }
            if (comparedValue < 0) {
                this.beforeFirst();
                return;
            }
            this.userIdxCursor.after((Entry)((Object)element));
            this.setAvailable(false);
        } else {
            super.after(element);
        }
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            ForwardIndexEntry advanceTo = new ForwardIndexEntry();
            advanceTo.setKey(this.greaterEqEvaluator.getExpression().getValue().getValue());
            this.userIdxCursor.before((Entry)((Object)advanceTo));
        } else {
            this.uuidIdxCursor.beforeFirst();
            this.uuidCandidate = null;
        }
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.uuidIdxCursor.afterLast();
            this.uuidCandidate = null;
        }
        this.setAvailable(false);
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.userIdxCursor != null) {
            while (this.userIdxCursor.previous()) {
                this.checkNotClosed("previous()");
                IndexEntry candidate = (IndexEntry)this.userIdxCursor.get();
                if (this.greaterEqEvaluator.getComparator().compare(candidate.getKey(), this.greaterEqEvaluator.getExpression().getValue().getValue()) < 0) continue;
                return this.setAvailable(true);
            }
            return this.setAvailable(false);
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            this.uuidCandidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.uuidCandidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.userIdxCursor != null) {
            return this.setAvailable(this.userIdxCursor.next());
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            this.uuidCandidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.uuidCandidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            if (this.available()) {
                return (IndexEntry)this.userIdxCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
        }
        if (this.available()) {
            return this.uuidCandidate;
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing GreaterEqCursor {}", this);
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
            this.uuidCandidate = null;
        }
    }

    @Override
    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing GreaterEqCursor {}", this);
        super.close(cause);
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close(cause);
        } else {
            this.uuidIdxCursor.close(cause);
            this.uuidCandidate = null;
        }
    }
}

