/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ChangeOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.AbandonListener;
import org.apache.directory.shared.ldap.model.message.AbandonableRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.ldap.model.message.controls.EntryChangeImpl;
import org.apache.directory.shared.ldap.model.message.controls.PersistentSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSearchListener
implements DirectoryListener,
AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentSearchListener.class);
    final LdapSession session;
    final SearchRequest req;
    final PersistentSearch psearchControl;

    PersistentSearchListener(LdapSession session, SearchRequest req) {
        this.session = session;
        this.req = req;
        req.addAbandonListener(this);
        this.psearchControl = (PersistentSearch)req.getControls().get("2.16.840.1.113730.3.4.3");
    }

    public void abandon() throws LdapException {
        this.session.getCoreSession().getDirectoryService().getEventService().removeListener(this);
    }

    @Override
    public void requestAbandoned(AbandonableRequest req) {
        try {
            this.abandon();
        }
        catch (LdapException e) {
            LOG.error(I18n.err(I18n.ERR_164, new Object[0]), e);
        }
    }

    private void setECResponseControl(SearchResultEntry response, ChangeOperationContext opContext, ChangeType type) {
        if (this.psearchControl.isReturnECs()) {
            EntryChangeImpl ecControl = new EntryChangeImpl();
            ecControl.setChangeType(type);
            if (opContext.getChangeLogEvent() != null) {
                ecControl.setChangeNumber(opContext.getChangeLogEvent().getRevision());
            }
            if (opContext instanceof RenameOperationContext || opContext instanceof MoveOperationContext) {
                ecControl.setPreviousDn(opContext.getDn());
            }
            response.addControl(ecControl);
        }
    }

    @Override
    public void entryAdded(AddOperationContext addContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.ADD)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(addContext.getDn());
        respEntry.setEntry(addContext.getEntry());
        this.setECResponseControl(respEntry, addContext, ChangeType.ADD);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryDeleted(DeleteOperationContext deleteContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.DELETE)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(deleteContext.getDn());
        respEntry.setEntry(deleteContext.getEntry());
        this.setECResponseControl(respEntry, deleteContext, ChangeType.DELETE);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryModified(ModifyOperationContext modifyContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.MODIFY)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(modifyContext.getDn());
        respEntry.setEntry(modifyContext.getAlteredEntry());
        this.setECResponseControl(respEntry, modifyContext, ChangeType.MODIFY);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryMoved(MoveOperationContext moveContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.MODDN)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(moveContext.getDn());
        respEntry.setEntry(moveContext.getEntry());
        this.setECResponseControl(respEntry, moveContext, ChangeType.MODDN);
        this.session.getIoSession().write(respEntry);
    }

    @Override
    public void entryMovedAndRenamed(MoveAndRenameOperationContext moveAndRenameContext) {
        this.entryRenamed(moveAndRenameContext);
    }

    @Override
    public void entryRenamed(RenameOperationContext renameContext) {
        if (!this.psearchControl.isNotificationEnabled(ChangeType.MODDN)) {
            return;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(this.req.getMessageId());
        respEntry.setObjectName(renameContext.getModifiedEntry().getDn());
        respEntry.setEntry(renameContext.getModifiedEntry());
        this.setECResponseControl(respEntry, renameContext, ChangeType.MODDN);
        this.session.getIoSession().write(respEntry);
    }
}

