/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddHandler
extends LdapRequestHandler<AddRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AddHandler.class);

    @Override
    public void handle(LdapSession session, AddRequest req) {
        LOG.debug("Handling request: {}", req);
        LdapResult result = ((AddResponse)req.getResultResponse()).getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.add(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

