/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.util.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueArrayCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final int BEFORE_FIRST = -1;
    private final K key;
    private final List<V> values;
    private final Tuple<K, V> tuple = new Tuple();
    private int pos = -1;

    public ValueArrayCursor(K key, V[] values) {
        LOG_CURSOR.debug("Creating ValueArrayCursor {}", this);
        this.key = key;
        this.tuple.setKey(key);
        this.values = Arrays.asList(values);
    }

    public ValueArrayCursor(K key, List<V> values) {
        LOG_CURSOR.debug("Creating ValueArrayCursor {}", this);
        this.key = key;
        this.tuple.setKey(key);
        this.values = values;
    }

    @Override
    public boolean available() {
        return this.inRangeOnValue();
    }

    @Override
    public void before(Tuple<K, V> element) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void after(Tuple<K, V> element) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.pos = -1;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.pos = this.values.size();
    }

    public boolean absolute(int absolutePosition) throws Exception {
        this.checkNotClosed("absolute()");
        if (absolutePosition >= this.values.size()) {
            this.pos = this.values.size();
            return false;
        }
        if (absolutePosition < 0) {
            this.pos = -1;
            return false;
        }
        this.pos = absolutePosition;
        return true;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        this.pos = 0;
        return true;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        this.pos = this.values.size() - 1;
        return true;
    }

    @Override
    public boolean isFirst() throws Exception {
        this.checkNotClosed("isFirst()");
        return this.pos == 0;
    }

    @Override
    public boolean isLast() throws Exception {
        this.checkNotClosed("isLast()");
        return this.pos == this.values.size() - 1;
    }

    @Override
    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("isAfterLast()");
        return this.pos == this.values.size();
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("isBeforeFirst()");
        return this.pos == -1;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.pos <= -1) {
            return false;
        }
        --this.pos;
        return this.inRangeOnValue();
    }

    private boolean inRangeOnValue() {
        return this.pos > -1 && this.pos < this.values.size();
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.pos >= this.values.size()) {
            return false;
        }
        ++this.pos;
        return this.inRangeOnValue();
    }

    @Override
    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.inRangeOnValue()) {
            return this.tuple.setBoth(this.key, this.values.get(this.pos));
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_701, this.pos, this.values.size() - 1));
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing ValueArrayCursor {}", this);
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing ValueArrayCursor {}", this);
        super.close(cause);
    }
}

