/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectiveAttributeInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(CollectiveAttributeInterceptor.class);
    private final EntryFilter SEARCH_FILTER = new CollectiveAttributeFilter();

    public CollectiveAttributeInterceptor() {
        super(InterceptorEnum.COLLECTIVE_ATTRIBUTE_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        LOG.debug("CollectiveAttribute interceptor initilaized");
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        this.checkAdd(addContext.getDn(), addContext.getEntry());
        this.next(addContext);
    }

    @Override
    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(listContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Entry result = this.next(lookupContext);
        if (lookupContext.getAttrsId() == null || lookupContext.getAttrsId().size() == 0) {
            this.addCollectiveAttributes(lookupContext, result, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        } else {
            this.addCollectiveAttributes(lookupContext, result, lookupContext.getAttrsIdArray());
        }
        return result;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        this.checkModify(modifyContext);
        this.next(modifyContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    private void checkAdd(Dn normName, Entry entry) throws LdapException {
        if (entry.hasObjectClass("collectiveAttributeSubentry")) {
            for (Attribute attribute : entry) {
                if (!attribute.getAttributeType().isCollective()) continue;
                return;
            }
            LOG.info("A CollectiveAttribute subentry *should* have at least one collectiveAttribute");
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_257_COLLECTIVE_SUBENTRY_WITHOUT_COLLECTIVE_AT, new Object[0]));
        }
        if (this.containsAnyCollectiveAttributes(entry)) {
            LOG.info("Cannot add the entry {} : it contains some CollectiveAttributes and is not a collective subentry", entry);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_241_CANNOT_STORE_COLLECTIVE_ATT_IN_ENTRY, new Object[0]));
        }
    }

    private void checkModify(ModifyOperationContext modifyContext) throws LdapException {
        List<Modification> mods = modifyContext.getModItems();
        Entry originalEntry = modifyContext.getEntry();
        Entry targetEntry = SchemaUtils.getTargetEntry(mods, originalEntry);
        if (targetEntry.contains(OBJECT_CLASS_AT, "collectiveAttributeSubentry")) {
            return;
        }
        if (this.hasCollectiveAttributes(mods)) {
            LOG.info("Cannot modify the entry {} : it contains some CollectiveAttributes and is not a collective subentry", targetEntry);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_242, new Object[0]));
        }
    }

    private boolean hasCollectiveAttributes(List<Modification> mods) throws LdapException {
        for (Modification mod : mods) {
            Attribute attr = mod.getAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType == null) {
                try {
                    attrType = this.schemaManager.lookupAttributeTypeRegistry(attr.getUpId());
                }
                catch (LdapException le) {
                    throw new LdapInvalidAttributeTypeException();
                }
            }
            ModificationOperation modOp = mod.getOperation();
            if (!attrType.isCollective() || modOp == ModificationOperation.REMOVE_ATTRIBUTE) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnyCollectiveAttributes(Entry entry) throws LdapException {
        for (Attribute attribute : entry.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            if (!attributeType.isCollective()) continue;
            return true;
        }
        return false;
    }

    private void addCollectiveAttributes(OperationContext opContext, Entry entry, String[] retAttrs) throws LdapException {
        Attribute collectiveAttributeSubentries = ((ClonedServerEntry)entry).getOriginalEntry().get(COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT);
        if (collectiveAttributeSubentries == null) {
            return;
        }
        Attribute collectiveExclusions = ((ClonedServerEntry)entry).getOriginalEntry().get(COLLECTIVE_EXCLUSIONS_AT);
        HashSet<String> exclusions = new HashSet<String>();
        if (collectiveExclusions != null) {
            if (collectiveExclusions.contains("2.5.18.0") || collectiveExclusions.contains("excludeAllCollectiveAttributes")) {
                return;
            }
            exclusions = new HashSet();
            for (Value value : collectiveExclusions) {
                AttributeType attrType = this.schemaManager.lookupAttributeTypeRegistry(value.getString());
                exclusions.add(attrType.getOid());
            }
        }
        if (retAttrs == null) {
            retAttrs = SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY;
        }
        HashSet<String> retIdsSet = new HashSet<String>(retAttrs.length);
        for (String retAttr : retAttrs) {
            if (retAttr.equals("*") || retAttr.equals("+")) {
                retIdsSet.add(retAttr);
                continue;
            }
            retIdsSet.add(this.schemaManager.lookupAttributeTypeRegistry(retAttr).getOid());
        }
        for (Value value : collectiveAttributeSubentries) {
            String subentryDnStr = value.getString();
            Dn subentryDn = opContext.getSession().getDirectoryService().getDnFactory().create(subentryDnStr);
            CoreSession session = opContext.getSession();
            LookupOperationContext lookupContext = new LookupOperationContext(session, subentryDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry subentry = session.getDirectoryService().getPartitionNexus().lookup(lookupContext);
            for (Attribute attribute : subentry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                String attrId = attributeType.getName();
                if (!attributeType.isCollective() || exclusions.contains(attributeType.getOid())) continue;
                Set<AttributeType> allSuperTypes = this.getAllSuperTypes(attributeType);
                for (String retId : retIdsSet) {
                    AttributeType retType;
                    if (retId.equals("*") || retId.equals("+") || !allSuperTypes.contains(retType = this.schemaManager.lookupAttributeTypeRegistry(retId))) continue;
                    retIdsSet.add(this.schemaManager.lookupAttributeTypeRegistry(attrId).getOid());
                    break;
                }
                if (!retIdsSet.contains("*") && !retIdsSet.contains(this.schemaManager.lookupAttributeTypeRegistry(attrId).getOid())) continue;
                Attribute subentryColAttr = subentry.get(attrId);
                Attribute entryColAttr = entry.get(attrId);
                if (entryColAttr == null) {
                    entryColAttr = new DefaultAttribute(this.schemaManager.lookupAttributeTypeRegistry(attrId));
                    entry.put(entryColAttr);
                }
                for (Value subentryColVal : subentryColAttr) {
                    entryColAttr.add(subentryColVal.getString());
                }
            }
        }
    }

    private Set<AttributeType> getAllSuperTypes(AttributeType id) throws LdapException {
        HashSet<AttributeType> allSuperTypes = new HashSet<AttributeType>();
        AttributeType superType = id;
        while (superType != null) {
            if ((superType = superType.getSuperior()) == null) continue;
            allSuperTypes.add(superType);
        }
        return allSuperTypes;
    }

    private class CollectiveAttributeFilter
    implements EntryFilter {
        private CollectiveAttributeFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext operation, Entry entry) throws Exception {
            String[] retAttrs = operation.getReturningAttributesString();
            CollectiveAttributeInterceptor.this.addCollectiveAttributes(operation, entry, retAttrs);
            return true;
        }
    }
}

