/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree.avl;

import java.util.Iterator;
import java.util.Stack;
import org.apache.directory.server.core.avltree.avl.AvlNode;
import org.apache.directory.server.core.avltree.avl.AvlTreeIterator;

public class AvlTreeSet<T extends Comparable<T>>
implements Iterable<T> {
    private AvlNode<T> tree;
    private int size = 0;
    final boolean useFreeList;
    Stack<AvlNode<T>> free_list = new Stack();

    public AvlTreeSet() {
        this(false);
    }

    public AvlTreeSet(boolean useFreeList) {
        this.useFreeList = useFreeList;
    }

    public final int height() {
        return this.tree == null ? 0 : this.tree.height + 1;
    }

    public final int size() {
        return this.size;
    }

    @Override
    public final Iterator<T> iterator() {
        return new AvlTreeIterator<T>(this.tree);
    }

    public final boolean insert(T value) {
        if (this.tree == null) {
            this.tree = this.new_node(null, value);
            ++this.size;
            return true;
        }
        AvlNode<T> node = this.tree;
        int cmp = value.compareTo(node.value);
        while (cmp != 0) {
            if (cmp < 0) {
                if (node.left == null) {
                    node.left = this.new_node(node, value);
                    break;
                }
                node = node.left;
            } else if (cmp > 0) {
                if (node.right == null) {
                    node.right = this.new_node(node, value);
                    break;
                }
                node = node.right;
            } else assert (false) : "should never happen";
            cmp = value.compareTo(node.value);
        }
        if (cmp == 0) {
            return false;
        }
        this.rebalance_up(node);
        ++this.size;
        return true;
    }

    private final AvlNode<T> new_node(AvlNode<T> parent, T value) {
        if (!this.useFreeList || this.free_list.isEmpty()) {
            return new AvlNode<T>(parent, value);
        }
        AvlNode<T> node = this.free_list.pop();
        return node.reset(parent, value);
    }

    private final void recycle_node(AvlNode<T> node) {
        if (!this.useFreeList) {
            return;
        }
        while (this.free_list.size() > this.size) {
            this.free_list.pop();
        }
        if (this.free_list.size() == this.size) {
            return;
        }
        this.free_list.push(node);
    }

    private void rebalance_up(AvlNode<T> node) {
        while (node != null) {
            int height_before = node.height;
            AvlTreeSet.update_height(node);
            if (node.balance == -2) {
                node = AvlTreeSet.big_right_rotation(node);
            } else if (node.balance == 2) {
                node = AvlTreeSet.big_left_rotation(node);
            }
            if (node.parent == null) {
                this.tree = node;
            }
            if (height_before == node.height) break;
            node = node.parent;
        }
    }

    public final boolean remove(T value) {
        AvlNode<T> node = this.tree;
        if (node == null) {
            return false;
        }
        int cmp = value.compareTo(node.value);
        while (cmp != 0) {
            AvlNode avlNode = node = cmp < 0 ? node.left : node.right;
            if (node == null) {
                return false;
            }
            cmp = value.compareTo(node.value);
        }
        int LEFT = -1;
        boolean RIGHT = true;
        boolean NONE = false;
        int replaceFrom = 0;
        if (node.left != null && node.right == null) {
            replaceFrom = -1;
        } else if (node.right != null && node.left == null) {
            replaceFrom = 1;
        } else if (node.right != null && node.left != null) {
            replaceFrom = node.balance < 0 ? -1 : (node.balance > 0 ? 1 : -1);
        } else {
            if (node.parent == null) {
                this.tree = null;
                --this.size;
                this.recycle_node(node);
                return true;
            }
            if (node.parent.left == node) {
                node.parent.left = null;
            } else {
                node.parent.right = null;
            }
            AvlNode<T> dead = node;
            node = node.parent;
            this.recycle_node(dead);
            replaceFrom = 0;
        }
        if (replaceFrom != 0) {
            AvlNode leaf = null;
            if (replaceFrom == -1) {
                leaf = node.left;
                while (leaf.left != null || leaf.right != null) {
                    if (leaf.right != null) {
                        leaf = leaf.right;
                        continue;
                    }
                    leaf = AvlTreeSet.small_right_rotation(leaf);
                }
            } else if (replaceFrom == 1) {
                leaf = node.right;
                while (leaf.right != null || leaf.left != null) {
                    if (leaf.left != null) {
                        leaf = leaf.left;
                        continue;
                    }
                    leaf = AvlTreeSet.small_left_rotation(leaf);
                }
            } else assert (false) : "should never happen";
            assert (leaf != null) : "replacement leaf should always exist at this point";
            if (leaf.parent.left == leaf) {
                leaf.parent.left = null;
            } else if (leaf.parent.right == leaf) {
                leaf.parent.right = null;
            } else assert (false) : "broken parent/child reference in the tree";
            node.value = leaf.value;
            node = leaf.parent;
            this.recycle_node(leaf);
        }
        this.rebalance_up(node);
        --this.size;
        return true;
    }

    public final boolean contains(T value) {
        AvlNode<T> node = this.tree;
        while (node != null) {
            int cmp = value.compareTo(node.value);
            if (cmp < 0) {
                node = node.left;
                continue;
            }
            if (cmp > 0) {
                node = node.right;
                continue;
            }
            return true;
        }
        return false;
    }

    private static final <T extends Comparable<T>> void update_height(AvlNode<T> node) {
        int left_height = node.left == null ? -1 : node.left.height;
        int right_height = node.right == null ? -1 : node.right.height;
        node.height = 1 + (right_height > left_height ? right_height : left_height);
        node.balance = right_height - left_height;
    }

    private static final <T extends Comparable<T>> AvlNode<T> small_left_rotation(AvlNode<T> node) {
        assert (node.balance > 0) : "null right child in small_left";
        AvlNode right = node.right;
        node.right = right.left;
        right.left = node;
        if (node.right != null) {
            node.right.parent = node;
        }
        right.parent = node.parent;
        if (right.parent != null) {
            if (right.parent.left == node) {
                node.parent.left = right;
            } else {
                node.parent.right = right;
            }
        }
        node.parent = right;
        AvlTreeSet.update_height(node);
        AvlTreeSet.update_height(right);
        return right;
    }

    private static final <T extends Comparable<T>> AvlNode<T> small_right_rotation(AvlNode<T> node) {
        assert (node.balance < 0) : "null left child in small_right";
        AvlNode left = node.left;
        node.left = left.right;
        left.right = node;
        if (node.left != null) {
            node.left.parent = node;
        }
        left.parent = node.parent;
        if (left.parent != null) {
            if (left.parent.left == node) {
                node.parent.left = left;
            } else {
                node.parent.right = left;
            }
        }
        node.parent = left;
        AvlTreeSet.update_height(node);
        AvlTreeSet.update_height(left);
        return left;
    }

    private static final <T extends Comparable<T>> AvlNode<T> big_left_rotation(AvlNode<T> node) {
        assert (node.right != null) : "null right child in big_left";
        if (node.right.balance < 0) {
            node.right = AvlTreeSet.small_right_rotation(node.right);
        }
        AvlTreeSet.update_height(node);
        return AvlTreeSet.small_left_rotation(node);
    }

    private static final <T extends Comparable<T>> AvlNode<T> big_right_rotation(AvlNode<T> node) {
        assert (node.left != null) : "null right child in big_right";
        if (node.left.balance > 0) {
            node.left = AvlTreeSet.small_left_rotation(node.left);
        }
        AvlTreeSet.update_height(node);
        return AvlTreeSet.small_right_rotation(node);
    }
}

