/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.util.Comparator;
import org.apache.directory.server.core.avltree.AvlTreeMap;
import org.apache.directory.server.core.avltree.LinkedAvlMapNode;
import org.apache.directory.server.core.avltree.Position;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.apache.directory.shared.ldap.model.cursor.AbstractTupleCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.Tuple;

public class AvlSingletonOrOrderedSetCursor<K, V>
extends AbstractTupleCursor<K, SingletonOrOrderedSet<V>> {
    private AvlTreeMap<K, V> tree;
    private LinkedAvlMapNode<K, V> node;
    private Position position = Position.BEFORE_FIRST;
    private Tuple<K, SingletonOrOrderedSet<V>> returnedTuple = new Tuple();

    public AvlSingletonOrOrderedSetCursor(AvlTreeMap<K, V> tree) {
        this.tree = tree;
    }

    public Comparator<K> getKeyComparator() {
        return this.tree.getKeyComparator();
    }

    public Comparator<V> getValuComparator() {
        return this.tree.getValueComparator();
    }

    @Override
    public void after(Tuple<K, SingletonOrOrderedSet<V>> element) throws Exception {
        this.afterKey(element.getKey());
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast");
        this.node = null;
        this.position = Position.AFTER_LAST;
    }

    @Override
    public boolean available() {
        return this.position == Position.ON_NODE;
    }

    @Override
    public void before(Tuple<K, SingletonOrOrderedSet<V>> element) throws Exception {
        this.beforeKey(element.getKey());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst");
        this.node = null;
        this.position = Position.BEFORE_FIRST;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first");
        this.node = this.tree.getFirst();
        if (this.node == null) {
            this.position = Position.BEFORE_FIRST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public Tuple<K, SingletonOrOrderedSet<V>> get() throws Exception {
        this.checkNotClosed("get");
        if (this.position == Position.ON_NODE) {
            this.returnedTuple.setKey(this.node.key);
            this.returnedTuple.setValue(this.node.value);
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last");
        this.node = this.tree.getLast();
        if (this.node == null) {
            this.position = Position.AFTER_LAST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next");
        switch (this.position) {
            case BEFORE_FIRST: {
                return this.first();
            }
            case BEFORE_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case ON_NODE: 
            case AFTER_NODE: {
                this.node = this.node.next;
                if (this.node == null) {
                    this.afterLast();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous");
        switch (this.position) {
            case BEFORE_FIRST: {
                return false;
            }
            case BEFORE_NODE: 
            case ON_NODE: {
                this.node = this.node.previous;
                if (this.node == null) {
                    this.beforeFirst();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return this.last();
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    @Override
    public void afterKey(K key) throws Exception {
        this.checkNotClosed("afterKey");
        if (key == null) {
            this.afterLast();
            return;
        }
        this.node = this.tree.findGreater(key);
        this.position = this.node == null ? Position.AFTER_LAST : Position.BEFORE_NODE;
    }

    @Override
    public void afterValue(K key, SingletonOrOrderedSet<V> value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    @Override
    public void beforeKey(K key) throws Exception {
        this.checkNotClosed("beforeKey");
        if (key == null) {
            this.beforeFirst();
            return;
        }
        this.node = this.tree.findLess(key);
        this.position = this.node == null ? Position.BEFORE_FIRST : Position.AFTER_NODE;
    }

    @Override
    public void beforeValue(K key, SingletonOrOrderedSet<V> value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }
}

