/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;

public class RenameOperationContext
extends AbstractChangeOperationContext {
    protected Rdn newRdn;
    protected Dn newDn;
    private boolean deleteOldRdn;

    public RenameOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.RENAME));
        }
    }

    public RenameOperationContext(CoreSession session, Dn oldDn, Rdn newRdn, boolean deleteOldRdn) {
        super(session, oldDn);
        this.newRdn = newRdn;
        this.deleteOldRdn = deleteOldRdn;
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.RENAME));
        }
    }

    public RenameOperationContext(CoreSession session, ModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest.getName());
        this.newRdn = modifyDnRequest.getNewRdn();
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.RENAME));
        }
        if (this.newRdn == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_328, modifyDnRequest));
        }
        this.deleteOldRdn = modifyDnRequest.getDeleteOldRdn();
        this.requestControls = modifyDnRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public boolean getDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDelOldDn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public Dn getNewDn() {
        return this.newDn;
    }

    public Rdn getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(Rdn newRdn) {
        this.newRdn = newRdn;
    }

    public void setNewDn(Dn newDn) {
        this.newDn = newDn;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.MODIFYDN_REQUEST.name();
    }

    public String toString() {
        return "RenameContext for old Dn '" + this.getDn().getName() + "'" + ", new Rdn '" + this.newRdn + "'" + (this.deleteOldRdn ? ", delete old Rdn" : "");
    }
}

