/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;

public class Cancel
extends AbstractAsn1Object {
    private int cancelId;
    private int cancelSequenceLength;

    public Cancel(int cancelId) {
        this.cancelId = cancelId;
    }

    public Cancel() {
    }

    public int getCancelId() {
        return this.cancelId;
    }

    public void setCancelId(int cancelId) {
        this.cancelId = cancelId;
    }

    public int computeLength() {
        this.cancelSequenceLength = 2 + Value.getNbBytes(this.cancelId);
        return 2 + this.cancelSequenceLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.cancelSequenceLength));
        Value.encode(bb, this.cancelId);
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cancel extended operation");
        sb.append("    cancelId : ").append(this.cancelId).append('\n');
        return sb.toString();
    }
}

