/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.entry;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.ldap.model.schema.normalizers.DeepTrimToLowerNormalizer;
import org.apache.directory.shared.util.Strings;

public class TestServerEntryUtils {
    public static MatchingRule matchingRuleFactory(String oid) {
        MatchingRule matchingRule = new MatchingRule(oid);
        return matchingRule;
    }

    public static LdapSyntax syntaxFactory(String oid, boolean humanReadable) {
        LdapSyntax ldapSyntax = new LdapSyntax(oid);
        ldapSyntax.setHumanReadable(humanReadable);
        return ldapSyntax;
    }

    static AttributeType getCaseIgnoringAttributeNoNumbersType() {
        AttributeType attributeType = new AttributeType("1.1.3.1");
        LdapSyntax syntax = new LdapSyntax("1.1.1.1", "", true);
        syntax.setSyntaxChecker(new SyntaxChecker("1.1.2.1"){

            @Override
            public boolean isValidSyntax(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                String strval = (String)value;
                for (char c : strval.toCharArray()) {
                    if (!Character.isDigit(c)) continue;
                    return false;
                }
                return true;
            }
        });
        MatchingRule matchingRule = new MatchingRule("1.1.2.1");
        matchingRule.setSyntax(syntax);
        matchingRule.setLdapComparator(new LdapComparator<String>(matchingRule.getOid()){

            @Override
            public int compare(String o1, String o2) {
                return o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            }

            int getValue(String val) {
                if (val.equals("LOW")) {
                    return 0;
                }
                if (val.equals("MEDIUM")) {
                    return 1;
                }
                if (val.equals("HIGH")) {
                    return 2;
                }
                throw new IllegalArgumentException(I18n.err(I18n.ERR_472, new Object[0]));
            }
        });
        Normalizer normalizer = new Normalizer("1.1.1"){

            @Override
            public Value<?> normalize(Value<?> value) throws LdapException {
                if (value.isHumanReadable()) {
                    return new StringValue(Strings.toLowerCase(value.getString()));
                }
                throw new IllegalStateException(I18n.err(I18n.ERR_473, new Object[0]));
            }

            @Override
            public String normalize(String value) throws LdapException {
                return Strings.toLowerCase(value);
            }
        };
        matchingRule.setNormalizer(normalizer);
        attributeType.setEquality(matchingRule);
        attributeType.setSyntax(syntax);
        return attributeType;
    }

    static AttributeType getIA5StringAttributeType() {
        AttributeType attributeType = new AttributeType("1.1");
        attributeType.addName("1.1");
        LdapSyntax syntax = new LdapSyntax("1.1.1", "", true);
        syntax.setSyntaxChecker(new SyntaxChecker("1.1.2"){

            @Override
            public boolean isValidSyntax(Object value) {
                return (String)value == null || ((String)value).length() < 7;
            }
        });
        MatchingRule matchingRule = new MatchingRule("1.1.2");
        matchingRule.setSyntax(syntax);
        matchingRule.setLdapComparator(new LdapComparator<String>(matchingRule.getOid()){

            @Override
            public int compare(String o1, String o2) {
                return o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            }
        });
        matchingRule.setNormalizer(new DeepTrimToLowerNormalizer(matchingRule.getOid()));
        attributeType.setEquality(matchingRule);
        attributeType.setSyntax(syntax);
        return attributeType;
    }

    static AttributeType getBytesAttributeType() {
        AttributeType attributeType = new AttributeType("1.2");
        LdapSyntax syntax = new LdapSyntax("1.2.1", "", true);
        syntax.setSyntaxChecker(new SyntaxChecker("1.2.1"){

            @Override
            public boolean isValidSyntax(Object value) {
                return value == null || ((byte[])value).length < 5;
            }
        });
        MatchingRule matchingRule = new MatchingRule("1.2.2");
        matchingRule.setSyntax(syntax);
        matchingRule.setLdapComparator(new ByteArrayComparator("1.2.2"));
        matchingRule.setNormalizer(new Normalizer("1.1.1"){

            @Override
            public Value<?> normalize(Value<?> value) throws LdapException {
                if (!value.isHumanReadable()) {
                    byte[] val = value.getBytes();
                    byte[] newVal = new byte[val.length];
                    int i = 0;
                    for (byte b : val) {
                        newVal[i++] = (byte)(b & 0x7F);
                    }
                    return new BinaryValue(Strings.trim(newVal));
                }
                throw new IllegalStateException(I18n.err(I18n.ERR_474, new Object[0]));
            }

            @Override
            public String normalize(String value) throws LdapException {
                throw new IllegalStateException(I18n.err(I18n.ERR_474, new Object[0]));
            }
        });
        attributeType.setEquality(matchingRule);
        attributeType.setSyntax(syntax);
        return attributeType;
    }

    static class S
    extends LdapSyntax {
        private static final long serialVersionUID = 0L;

        public S(String oid, boolean humanReadible) {
            super(oid, "", humanReadible);
        }
    }

    static class MR
    extends MatchingRule {
        protected MR(String oid) {
            super(oid);
        }
    }

    static class AT
    extends AttributeType {
        private static final long serialVersionUID = 0L;

        protected AT(String oid) {
            super(oid);
        }
    }
}

