/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.Module;

class EntryFilterEnumeration
implements Enumeration {
    private final BundleImpl m_bundle;
    private final List<Enumeration> m_enumerations;
    private final List<Module> m_modules;
    private int m_moduleIndex = 0;
    private final String m_path;
    private final List<String> m_filePattern;
    private final boolean m_recurse;
    private final boolean m_isURLValues;
    private final Set<String> m_dirEntries = new HashSet<String>();
    private final List<Object> m_nextEntries = new ArrayList<Object>(2);

    public EntryFilterEnumeration(BundleImpl bundle, boolean includeFragments, String path, String filePattern, boolean recurse, boolean isURLValues) {
        this.m_bundle = bundle;
        Module bundleModule = this.m_bundle.getCurrentModule();
        List<Module> fragmentModules = ((ModuleImpl)bundleModule).getFragments();
        if (includeFragments && fragmentModules != null) {
            this.m_modules = new ArrayList<Module>(fragmentModules.size() + 1);
            this.m_modules.addAll(fragmentModules);
        } else {
            this.m_modules = new ArrayList<Module>(1);
        }
        this.m_modules.add(0, bundleModule);
        this.m_enumerations = new ArrayList<Enumeration>(this.m_modules.size());
        for (int i = 0; i < this.m_modules.size(); ++i) {
            this.m_enumerations.add(this.m_modules.get(i).getContent() != null ? this.m_modules.get(i).getContent().getEntries() : null);
        }
        this.m_recurse = recurse;
        this.m_isURLValues = isURLValues;
        if (path == null) {
            throw new IllegalArgumentException("The path for findEntries() cannot be null.");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        this.m_path = path;
        filePattern = filePattern == null ? "*" : filePattern;
        this.m_filePattern = SimpleFilter.parseSubstring(filePattern);
        this.findNext();
    }

    public synchronized boolean hasMoreElements() {
        return !this.m_nextEntries.isEmpty();
    }

    public synchronized Object nextElement() {
        if (this.m_nextEntries.isEmpty()) {
            throw new NoSuchElementException("No more entries.");
        }
        Object last = this.m_nextEntries.remove(0);
        this.findNext();
        return last;
    }

    private void findNext() {
        if (this.m_enumerations == null) {
            return;
        }
        while (this.m_moduleIndex < this.m_enumerations.size() && this.m_nextEntries.isEmpty()) {
            while (this.m_enumerations.get(this.m_moduleIndex) != null && this.m_enumerations.get(this.m_moduleIndex).hasMoreElements() && this.m_nextEntries.isEmpty()) {
                String entryName = (String)this.m_enumerations.get(this.m_moduleIndex).nextElement();
                if (entryName.equals(this.m_path) || !entryName.startsWith(this.m_path)) continue;
                URL entryURL = null;
                int dirSlashIdx = entryName.indexOf(47, this.m_path.length());
                if (dirSlashIdx >= 0) {
                    int subDirSlashIdx = dirSlashIdx;
                    do {
                        String dir;
                        if (!this.m_dirEntries.contains(dir = entryName.substring(0, subDirSlashIdx + 1))) {
                            this.m_dirEntries.add(dir);
                            if (SimpleFilter.compareSubstring(this.m_filePattern, EntryFilterEnumeration.getLastPathElement(dir))) {
                                if (this.m_isURLValues) {
                                    entryURL = entryURL == null ? this.m_modules.get(this.m_moduleIndex).getEntry(entryName) : entryURL;
                                    try {
                                        this.m_nextEntries.add(new URL(entryURL, "/" + dir));
                                    }
                                    catch (MalformedURLException ex) {}
                                } else {
                                    this.m_nextEntries.add(dir);
                                }
                            }
                        }
                        subDirSlashIdx = entryName.indexOf(47, dir.length());
                    } while (this.m_recurse && subDirSlashIdx >= 0);
                }
                if (this.m_dirEntries.contains(entryName) || !this.m_recurse && dirSlashIdx >= 0 && dirSlashIdx != entryName.length() - 1 || !SimpleFilter.compareSubstring(this.m_filePattern, EntryFilterEnumeration.getLastPathElement(entryName))) continue;
                if (this.m_isURLValues) {
                    entryURL = entryURL == null ? this.m_modules.get(this.m_moduleIndex).getEntry(entryName) : entryURL;
                    this.m_nextEntries.add(entryURL);
                    continue;
                }
                this.m_nextEntries.add(entryName);
            }
            if (!this.m_nextEntries.isEmpty()) continue;
            ++this.m_moduleIndex;
            this.m_dirEntries.clear();
        }
    }

    private static String getLastPathElement(String entryName) {
        int endIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.length() - 1 : entryName.length();
        int startIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.lastIndexOf(47, endIdx - 1) + 1 : entryName.lastIndexOf(47, endIdx) + 1;
        return entryName.substring(startIdx, endIdx);
    }
}

