/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchingRuleDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(MatchingRuleDescriptionSchemaParser.class);

    public synchronized MatchingRule parseMatchingRuleDescription(String matchingRuleDescription) throws ParseException {
        LOG.debug("Parsing a MatchingRule : {}", (Object)matchingRuleDescription);
        if (matchingRuleDescription == null) {
            LOG.error(I18n.err(I18n.ERR_04242, new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(matchingRuleDescription);
        try {
            MatchingRule matchingRule = this.parser.matchingRuleDescription();
            MatchingRuleDescriptionSchemaParser.updateSchemaName(matchingRule);
            return matchingRule;
        }
        catch (RecognitionException re) {
            String msg = I18n.err(I18n.ERR_04243, matchingRuleDescription, re.getMessage(), re.getColumn());
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err(I18n.ERR_04244, matchingRuleDescription, tse.getMessage());
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public MatchingRule parse(String schemaDescription) throws ParseException {
        return this.parseMatchingRuleDescription(schemaDescription);
    }
}

