/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl.certGeneration;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.ldap.extras.extended.CertGenerationRequest;
import org.apache.directory.shared.util.Strings;

public class CertGenerationObject
extends AbstractAsn1Object {
    private CertGenerationRequest request;
    private int requestLength = 0;

    public CertGenerationObject(CertGenerationRequest request) {
        this.request = request;
    }

    public int computeLength() {
        int len = Strings.getBytesUtf8(this.request.getTargetDN()).length;
        this.requestLength = 1 + Value.getNbBytes(len) + len;
        len = Strings.getBytesUtf8(this.request.getIssuerDN()).length;
        this.requestLength += 1 + Value.getNbBytes(len) + len;
        len = Strings.getBytesUtf8(this.request.getSubjectDN()).length;
        this.requestLength += 1 + Value.getNbBytes(len) + len;
        len = Strings.getBytesUtf8(this.request.getKeyAlgorithm()).length;
        this.requestLength += 1 + Value.getNbBytes(len) + len;
        return 1 + Value.getNbBytes(this.requestLength) + this.requestLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(Value.getBytes(this.requestLength));
        Value.encode(bb, this.request.getTargetDN());
        Value.encode(bb, this.request.getIssuerDN());
        Value.encode(bb, this.request.getSubjectDN());
        Value.encode(bb, this.request.getKeyAlgorithm());
        return bb;
    }
}

