/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls;

import java.util.Arrays;
import org.apache.directory.shared.ldap.extras.controls.SyncRequestValue;
import org.apache.directory.shared.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.shared.ldap.model.message.controls.AbstractControl;
import org.apache.directory.shared.util.Strings;

public class SyncRequestValueImpl
extends AbstractControl
implements SyncRequestValue {
    private SynchronizationModeEnum mode;
    private byte[] cookie;
    private boolean isReloadHint;

    public SyncRequestValueImpl() {
        super("1.3.6.1.4.1.4203.1.9.1.1");
    }

    public SyncRequestValueImpl(boolean isCritical) {
        super("1.3.6.1.4.1.4203.1.9.1.1", isCritical);
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public SynchronizationModeEnum getMode() {
        return this.mode;
    }

    public void setMode(SynchronizationModeEnum mode) {
        this.mode = mode;
    }

    public boolean isReloadHint() {
        return this.isReloadHint;
    }

    public void setReloadHint(boolean reloadHint) {
        this.isReloadHint = reloadHint;
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.isReloadHint ? 1 : 0);
        h = h * 17 + this.mode.getValue();
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SyncRequestValue)) {
            return false;
        }
        SyncRequestValue otherControl = (SyncRequestValue)o;
        return this.mode == otherControl.getMode() && this.isReloadHint == otherControl.isReloadHint() && Arrays.equals(this.cookie, otherControl.getCookie());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncRequestValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        mode              : '").append((Object)this.getMode()).append("'\n");
        sb.append("        cookie            : '").append(Strings.dumpBytes(this.getCookie())).append("'\n");
        sb.append("        reloadHint : '").append(this.isReloadHint()).append("'\n");
        return sb.toString();
    }
}

