/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.intermediateResponse;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.IntermediateResponseDecorator;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreIntermediateResponseValue
extends GrammarAction<LdapMessageContainer<IntermediateResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreIntermediateResponseValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreIntermediateResponseValue() {
        super("Store response value");
    }

    @Override
    public void action(LdapMessageContainer<IntermediateResponseDecorator> container) throws DecoderException {
        IntermediateResponse intermediateResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            intermediateResponse.setResponseValue(StringConstants.EMPTY_BYTES);
        } else {
            intermediateResponse.setResponseValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Value read : {}", (Object)Strings.dumpBytes(intermediateResponse.getResponseValue()));
        }
    }
}

