/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.bindRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreName
extends GrammarAction<LdapMessageContainer<BindRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreName() {
        super("Store BindRequest Name value");
    }

    @Override
    public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
        BindRequest bindRequestMessage = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            bindRequestMessage.setName(Dn.EMPTY_DN);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString(dnBytes);
            try {
                Dn dn = new Dn(dnStr);
                bindRequestMessage.setName(dn);
            }
            catch (LdapInvalidDnException ine) {
                String msg = "Incorrect Dn given : " + dnStr + " (" + Strings.dumpBytes(dnBytes) + ") is invalid";
                LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                BindResponseImpl response = new BindResponseImpl(bindRequestMessage.getMessageId());
                throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
            }
        }
        if (IS_DEBUG) {
            LOG.debug(" The Bind name is {}", bindRequestMessage.getName());
        }
    }
}

