/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public interface Store<E, ID extends Comparable<ID>> {
    public static final String[] SYS_INDEX_OID_ARRAY = new String[]{"1.3.6.1.4.1.18060.0.4.1.2.3", "1.3.6.1.4.1.18060.0.4.1.2.4", "1.3.6.1.4.1.18060.0.4.1.2.43", "1.3.6.1.4.1.18060.0.4.1.2.50", "1.3.6.1.4.1.18060.0.4.1.2.1", "1.3.6.1.4.1.18060.0.4.1.2.7", "1.3.6.1.4.1.18060.0.4.1.2.5", "1.3.6.1.4.1.18060.0.4.1.2.6", "1.3.6.1.4.1.4203.666.1.7", "1.3.6.1.1.16.4", "2.5.4.0"};
    public static final Set<String> SYS_INDEX_OIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SYS_INDEX_OID_ARRAY)));

    public void setPartitionPath(URI var1);

    public URI getPartitionPath();

    public ID getRootId();

    public void setSyncOnWrite(boolean var1);

    public boolean isSyncOnWrite();

    public void setCacheSize(int var1);

    public int getCacheSize();

    public void addIndex(Index<?, E, ID> var1) throws Exception;

    public Index<String, E, ID> getPresenceIndex();

    public Index<ID, E, ID> getOneLevelIndex();

    public Index<ID, E, ID> getSubLevelIndex();

    public Index<String, E, ID> getAliasIndex();

    public Index<ID, E, ID> getOneAliasIndex();

    public Index<ID, E, ID> getSubAliasIndex();

    public Index<ParentIdAndRdn<ID>, E, ID> getRdnIndex();

    public Index<String, E, ID> getObjectClassIndex();

    public Index<String, E, ID> getEntryUuidIndex();

    public Index<String, E, ID> getEntryCsnIndex();

    public Iterator<String> getUserIndices();

    public Iterator<String> getSystemIndices();

    public boolean hasIndexOn(AttributeType var1) throws Exception;

    public boolean hasUserIndexOn(AttributeType var1) throws Exception;

    public boolean hasSystemIndexOn(AttributeType var1) throws Exception;

    public Index<?, E, ID> getIndex(AttributeType var1) throws IndexNotFoundException;

    public Index<?, E, ID> getUserIndex(AttributeType var1) throws IndexNotFoundException;

    public Index<?, E, ID> getSystemIndex(AttributeType var1) throws IndexNotFoundException;

    public ID getEntryId(Dn var1) throws Exception;

    public Dn getEntryDn(ID var1) throws Exception;

    public ID getParentId(ID var1) throws Exception;

    public int count() throws Exception;

    public void delete(ID var1) throws Exception;

    public IndexCursor<ID, E, ID> list(ID var1) throws Exception;

    public Entry lookup(ID var1) throws Exception;

    public int getChildCount(ID var1) throws Exception;

    public Entry modify(Dn var1, Modification ... var2) throws Exception;

    public void rename(Dn var1, Rdn var2, boolean var3, Entry var4) throws Exception;

    public void moveAndRename(Dn var1, Dn var2, Rdn var3, Entry var4, boolean var5) throws Exception;

    public void move(Dn var1, Dn var2, Dn var3, Entry var4) throws Exception;

    public ID getDefaultId() throws Exception;
}

