/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplConsumerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReplConsumerManager.class);
    private static final Logger PROVIDER_LOG = LoggerFactory.getLogger("PROVIDER_LOG");
    private CoreSession adminSession;
    private DirectoryService directoryService;
    private SchemaManager schemaManager;
    private static final String REPL_CONSUMER_DN_STR = "ou=consumers,ou=system";
    private static Dn REPL_CONSUMER_DN;
    private static final String CONSUMERS = "consumers";
    private static AttributeType OBJECT_CLASS_AT;
    private static AttributeType ADS_REPL_LAST_SENT_CSN_AT;
    private Map<Integer, Modification> modMap = new ConcurrentHashMap<Integer, Modification>();

    public ReplConsumerManager(DirectoryService directoryService) throws Exception {
        this.directoryService = directoryService;
        this.adminSession = directoryService.getAdminSession();
        this.schemaManager = directoryService.getSchemaManager();
        REPL_CONSUMER_DN = directoryService.getDnFactory().create(REPL_CONSUMER_DN_STR);
        OBJECT_CLASS_AT = this.schemaManager.lookupAttributeTypeRegistry("objectClass");
        ADS_REPL_LAST_SENT_CSN_AT = this.schemaManager.lookupAttributeTypeRegistry("ads-replLastSentCsn");
        PROVIDER_LOG.debug("Starting the replication consumer manager");
        this.createConsumersBranch();
    }

    private void createConsumersBranch() throws Exception {
        if (!this.adminSession.exists(REPL_CONSUMER_DN)) {
            LOG.debug("creating the entry for storing replication consumers' details");
            PROVIDER_LOG.debug("Creating the entry for storing replication consumers' details in {}", REPL_CONSUMER_DN);
            DefaultEntry entry = new DefaultEntry(this.schemaManager, REPL_CONSUMER_DN, "objectClass", "organizationalUnit", "ou", CONSUMERS);
            this.adminSession.add(entry);
        }
    }

    public void addConsumerEntry(ReplicaEventLog replica) throws Exception {
        if (replica == null) {
            return;
        }
        PROVIDER_LOG.debug("Adding a consumer for replica {}", (Object)replica.toString());
        Dn consumerDn = this.directoryService.getDnFactory().create("ads-dsReplicaId=" + replica.getId() + "," + REPL_CONSUMER_DN);
        if (this.adminSession.exists(consumerDn)) {
            String message = "The replica " + consumerDn.getName() + " already exists";
            LOG.error(message);
            PROVIDER_LOG.debug(message);
            throw new LdapEntryAlreadyExistsException(message);
        }
        DefaultEntry entry = new DefaultEntry(this.schemaManager, consumerDn, "objectClass", "ads-replEventLog", "ads-dsReplicaId", String.valueOf(replica.getId()), "ads-replAliasDerefMode", replica.getSearchCriteria().getAliasDerefMode().getJndiValue(), "ads-searchBaseDN", replica.getSearchCriteria().getBase().getName(), "ads-replLastSentCsn", replica.getLastSentCsn(), "ads-replSearchScope", replica.getSearchCriteria().getScope().getLdapUrlValue(), "ads-replRefreshNPersist", String.valueOf(replica.isRefreshNPersist()), "ads-replSearchFilter", replica.getSearchFilter());
        this.adminSession.add(entry);
        LOG.debug("stored replication consumer entry {}", consumerDn);
    }

    public void deleteConsumerEntry(ReplicaEventLog replica) throws Exception {
        if (replica == null) {
            return;
        }
        Dn consumerDn = this.directoryService.getDnFactory().create("ads-dsReplicaId=" + replica.getId() + "," + REPL_CONSUMER_DN);
        PROVIDER_LOG.debug("Deleting the {} consumer", consumerDn);
        if (!this.adminSession.exists(consumerDn)) {
            String message = "The replica " + consumerDn.getName() + " does not exist";
            LOG.error(message);
            PROVIDER_LOG.debug(message);
            throw new LdapEntryAlreadyExistsException(message);
        }
        this.adminSession.delete(consumerDn);
        LOG.debug("Deleted replication consumer entry {}", consumerDn);
    }

    public void updateReplicaLastSentCsn(ReplicaEventLog replica) throws Exception {
        Modification mod = this.modMap.get(replica.getId());
        Attribute lastSentCsnAt = null;
        if (mod == null) {
            lastSentCsnAt = new DefaultAttribute(ADS_REPL_LAST_SENT_CSN_AT, replica.getLastSentCsn());
            mod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, lastSentCsnAt);
            this.modMap.put(replica.getId(), mod);
        } else {
            lastSentCsnAt = mod.getAttribute();
            lastSentCsnAt.clear();
            lastSentCsnAt.add(replica.getLastSentCsn());
        }
        Dn dn = this.directoryService.getDnFactory().create("ads-dsReplicaId=" + replica.getId() + "," + REPL_CONSUMER_DN);
        this.adminSession.modify(dn, mod);
        LOG.debug("updated last sent CSN of consumer entry {}", dn);
        PROVIDER_LOG.debug("updated the LastSentCSN of consumer entry {}", dn);
    }

    public List<ReplicaEventLog> getReplicaEventLogs() throws Exception {
        ArrayList<ReplicaEventLog> replicas = new ArrayList<ReplicaEventLog>();
        EqualityNode<String> filter = new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("ads-replEventLog"));
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(REPL_CONSUMER_DN);
        searchRequest.setScope(SearchScope.ONELEVEL);
        searchRequest.setFilter(filter);
        searchRequest.addAttributes("+", "*");
        EntryFilteringCursor cursor = this.adminSession.search(searchRequest);
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            ReplicaEventLog replica = this.convertEntryToReplica(entry);
            replicas.add(replica);
        }
        cursor.close();
        return replicas;
    }

    private ReplicaEventLog convertEntryToReplica(Entry entry) throws Exception {
        String id = entry.get("ads-dsReplicaId").getString();
        ReplicaEventLog replica = new ReplicaEventLog(this.directoryService, Integer.parseInt(id));
        NotificationCriteria searchCriteria = new NotificationCriteria();
        String aliasMode = entry.get("ads-replAliasDerefMode").getString();
        searchCriteria.setAliasDerefMode(AliasDerefMode.getDerefMode(aliasMode));
        String baseDn = entry.get("ads-searchBaseDN").getString();
        searchCriteria.setBase(new Dn(this.schemaManager, baseDn));
        Attribute lastSentCsnAt = entry.get("ads-replLastSentCsn");
        if (lastSentCsnAt != null) {
            replica.setLastSentCsn(lastSentCsnAt.getString());
        }
        String scope = entry.get("ads-replSearchScope").getString();
        int scopeIntVal = SearchScope.getSearchScope(scope);
        searchCriteria.setScope(SearchScope.getSearchScope(scopeIntVal));
        String filter = entry.get("ads-replSearchFilter").getString();
        searchCriteria.setFilter(filter);
        replica.setSearchFilter(filter);
        replica.setRefreshNPersist(Boolean.parseBoolean(entry.get("ads-replRefreshNPersist").getString()));
        searchCriteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
        replica.setSearchCriteria(searchCriteria);
        replica.setDirty(false);
        return replica;
    }
}

