/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.EntrySerializer;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class ReplicaEventMessageSerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private transient EntrySerializer entrySerializer;
    private transient LdapApiService codec = LdapApiServiceFactory.getSingleton();
    private transient SchemaManager schemaManager;

    public ReplicaEventMessageSerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.entrySerializer = new EntrySerializer(schemaManager);
    }

    @Override
    public byte[] serialize(Object object) throws IOException {
        ReplicaEventMessage replicaEventMessage = (ReplicaEventMessage)object;
        Entry entry = replicaEventMessage.getEntry();
        ChangeType changeType = replicaEventMessage.getChangeType();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        entry.getDn().writeExternal(out);
        byte[] data = this.entrySerializer.serialize(entry);
        out.writeInt(data.length);
        out.write(data);
        out.writeByte(changeType.getValue());
        out.flush();
        return baos.toByteArray();
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        ReplicaEventMessage replicaEventMessage = null;
        try {
            Dn entryDn = new Dn(this.schemaManager);
            entryDn.readExternal(in);
            int length = in.readInt();
            byte[] data = new byte[length];
            in.readFully(data);
            Entry entry = (Entry)this.entrySerializer.deserialize(data);
            entry.setDn(entryDn);
            byte type = in.readByte();
            ChangeType changeType = ChangeType.getChangeType(type);
            replicaEventMessage = new ReplicaEventMessage(changeType, entry);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        return replicaEventMessage;
    }
}

