/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDnHandler
extends LdapRequestHandler<ModifyDnRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDnHandler.class);

    @Override
    public void handle(LdapSession session, ModifyDnRequest req) {
        LdapResult result = ((ModifyDnResponse)req.getResultResponse()).getLdapResult();
        LOG.debug("Handling modify dn request while ignoring referrals: {}", req);
        if (req.getName().isEmpty()) {
            String msg = "Modify Dn is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setDiagnosticMessage(msg);
            session.getIoSession().write(req.getResultResponse());
            return;
        }
        try {
            SchemaManager schemaManager = session.getCoreSession().getDirectoryService().getSchemaManager();
            Dn newRdn = new Dn(schemaManager, req.getNewRdn().getName());
            Dn oldRdn = new Dn(schemaManager, req.getName().getRdn().getName());
            boolean rdnChanged = req.getNewRdn() != null && !newRdn.getNormName().equals(oldRdn.getNormName());
            CoreSession coreSession = session.getCoreSession();
            if (rdnChanged) {
                if (req.getNewSuperior() != null) {
                    coreSession.moveAndRename(req);
                } else {
                    coreSession.rename(req);
                }
            } else if (req.getNewSuperior() != null) {
                req.setNewRdn(null);
                coreSession.move(req);
            } else {
                result.setDiagnosticMessage("Attempt to move entry onto itself.");
                result.setResultCode(ResultCodeEnum.ENTRY_ALREADY_EXISTS);
                result.setMatchedDn(req.getName());
                session.getIoSession().write(req.getResultResponse());
                return;
            }
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

