/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.subtree.Subentry;
import org.apache.directory.server.core.subtree.SubentryCache;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesDecorator;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.exception.LdapOtherException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.message.controls.Subentries;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.subtree.AdministrativeRole;
import org.apache.directory.shared.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.model.subtree.SubtreeSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubentryInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SubentryInterceptor.class);
    private static final String SUBENTRY_CONTROL = "1.3.6.1.4.1.4203.1.10.1";
    public static AttributeType[] SUBENTRY_OPATTRS;
    private final SubentryCache subentryCache = new SubentryCache();
    private SubtreeSpecificationParser ssParser;
    private SubtreeEvaluator evaluator;
    private PartitionNexus nexus;

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        SUBENTRY_OPATTRS = new AttributeType[]{ACCESS_CONTROL_SUBENTRIES_AT, SUBSCHEMA_SUBENTRY_AT, COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT, TRIGGER_EXECUTION_SUBENTRIES_AT};
        this.ssParser = new SubtreeSpecificationParser(this.schemaManager);
        this.evaluator = new SubtreeEvaluator(this.schemaManager);
        Set<String> suffixes = this.nexus.listSuffixes();
        EqualityNode<String> filter = new EqualityNode<String>(OBJECT_CLASS_AT, new StringValue("subentry"));
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"subtreeSpecification", "objectClass"});
        Dn adminDn = directoryService.getDnFactory().create("uid=admin,ou=system");
        for (String suffix : suffixes) {
            Dn suffixDn = directoryService.getDnFactory().create(suffix);
            DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(this.schemaManager, adminDn, AuthenticationLevel.STRONG), directoryService);
            SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, suffixDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    SubtreeSpecification ss;
                    Entry subentry = (Entry)subentries.get();
                    Dn subentryDn = subentry.getDn();
                    String subtree = subentry.get(SUBTREE_SPECIFICATION_AT).getString();
                    try {
                        ss = this.ssParser.parse(subtree);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed while parsing subtreeSpecification for " + subentryDn);
                        continue;
                    }
                    Subentry newSubentry = new Subentry();
                    newSubentry.setAdministrativeRoles(this.getSubentryAdminRoles(subentry));
                    newSubentry.setSubtreeSpecification(ss);
                    this.subentryCache.addSubentry(subentryDn, newSubentry);
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
    }

    private Set<AdministrativeRole> getSubentryAdminRoles(Entry subentry) throws LdapException {
        HashSet<AdministrativeRole> adminRoles = new HashSet<AdministrativeRole>();
        Attribute oc = subentry.get(OBJECT_CLASS_AT);
        if (oc == null) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_305, new Object[0]));
        }
        if (oc.contains("accessControlSubentry")) {
            adminRoles.add(AdministrativeRole.AccessControlInnerArea);
        }
        if (oc.contains("subschema")) {
            adminRoles.add(AdministrativeRole.SubSchemaSpecificArea);
        }
        if (oc.contains("collectiveAttributeSubentry")) {
            adminRoles.add(AdministrativeRole.CollectiveAttributeSpecificArea);
        }
        if (oc.contains("triggerExecutionSubentry")) {
            adminRoles.add(AdministrativeRole.TriggerExecutionInnerArea);
        }
        return adminRoles;
    }

    private boolean isSubentryVisible(OperationContext opContext) throws LdapException {
        if (!opContext.hasRequestControls()) {
            return false;
        }
        if (opContext.hasRequestControl(SUBENTRY_CONTROL)) {
            SubentriesDecorator subentriesDecorator = (SubentriesDecorator)opContext.getRequestControl(SUBENTRY_CONTROL);
            return ((Subentries)subentriesDecorator.getDecorated()).isVisible();
        }
        return false;
    }

    private void updateEntries(OperationEnum operation, CoreSession session, Dn subentryDn, Dn apDn, SubtreeSpecification ss, Dn baseDn, List<Attribute> operationalAttributes) throws LdapException {
        PresenceNode filter = new PresenceNode(OBJECT_CLASS_AT);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"+", "*"});
        SearchOperationContext searchOperationContext = new SearchOperationContext(session, baseDn, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
        try {
            while (subentries.next()) {
                Entry candidate = (Entry)subentries.get();
                Dn candidateDn = candidate.getDn();
                if (!this.evaluator.evaluate(ss, apDn, candidateDn, candidate)) continue;
                List<Modification> modifications = null;
                switch (operation) {
                    case ADD: {
                        modifications = this.getOperationalModsForAdd(candidate, operationalAttributes);
                        break;
                    }
                    case REMOVE: {
                        modifications = this.getOperationalModsForRemove(subentryDn, candidate);
                    }
                }
                LOG.debug("The entry {} has been evaluated to true for subentry {}", candidate.getDn(), (Object)subentryDn);
                this.nexus.modify(new ModifyOperationContext(session, candidateDn, modifications));
            }
            subentries.close();
        }
        catch (Exception e) {
            throw new LdapOtherException(e.getMessage(), e);
        }
        finally {
            try {
                subentries.close();
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
            }
        }
    }

    private boolean isNamingContext(Dn dn) throws LdapException {
        Dn namingContext = this.nexus.getSuffixDn(dn);
        return dn.equals(namingContext);
    }

    private void checkAdministrativeRole(OperationContext opContext, Dn apDn) throws LdapException {
        Entry administrationPoint = opContext.lookup(apDn, ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Attribute administrativeRole = administrationPoint.get(ADMINISTRATIVE_ROLE_AT);
        if (administrativeRole == null || administrativeRole.size() <= 0) {
            LOG.error("The entry on {} is not an AdministrativePoint", apDn);
            throw new LdapNoSuchAttributeException(I18n.err(I18n.ERR_306, apDn));
        }
    }

    private void setSubtreeSpecification(Subentry subentry, Entry entry) throws LdapException {
        SubtreeSpecification ss;
        String subtree = entry.get(SUBTREE_SPECIFICATION_AT).getString();
        try {
            ss = this.ssParser.parse(subtree);
        }
        catch (Exception e) {
            String msg = I18n.err(I18n.ERR_307, entry.getDn());
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        subentry.setSubtreeSpecification(ss);
    }

    private boolean hasAdministrativeDescendant(OperationContext opContext, Dn name) throws LdapException {
        PresenceNode filter = new PresenceNode(ADMINISTRATIVE_ROLE_AT);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        SearchOperationContext searchOperationContext = new SearchOperationContext(opContext.getSession(), name, filter, controls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
        EntryFilteringCursor aps = this.nexus.search(searchOperationContext);
        try {
            if (aps.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new LdapOperationException(e.getMessage(), e);
        }
        finally {
            try {
                aps.close();
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
            }
        }
        return false;
    }

    private List<Modification> getModsOnEntryRdnChange(Dn oldName, Dn newName, Entry entry) throws LdapException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        for (Dn subentryDn : this.subentryCache) {
            Attribute opAttr;
            ModificationOperation op;
            boolean isNewNameSelected;
            Dn apDn = subentryDn.getParent();
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldNameSelected = this.evaluator.evaluate(ss, apDn, oldName, entry);
            if (isOldNameSelected == (isNewNameSelected = this.evaluator.evaluate(ss, apDn, newName, entry))) continue;
            if (isOldNameSelected && !isNewNameSelected) {
                for (AttributeType operationalAttribute : SUBENTRY_OPATTRS) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    opAttr = entry.get(operationalAttribute);
                    if (opAttr == null) continue;
                    opAttr = opAttr.clone();
                    opAttr.remove(subentryDn.getNormName());
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modifications.add(new DefaultModification(op, opAttr));
                }
                continue;
            }
            if (!isNewNameSelected || isOldNameSelected) continue;
            for (AttributeType operationalAttribute : SUBENTRY_OPATTRS) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                opAttr = new DefaultAttribute(operationalAttribute);
                opAttr.add(subentryDn.getNormName());
                modifications.add(new DefaultModification(op, opAttr));
            }
        }
        return modifications;
    }

    private Set<AdministrativeRole> getSubentryTypes(Entry entry, List<Modification> mods) throws LdapException {
        Attribute ocFinalState = entry.get(OBJECT_CLASS_AT).clone();
        block5: for (Modification mod : mods) {
            if (!mod.getAttribute().getId().equalsIgnoreCase("objectClass") && !mod.getAttribute().getId().equalsIgnoreCase("2.5.4.0")) continue;
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    for (Value value : mod.getAttribute()) {
                        ocFinalState.add(value.getString());
                    }
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    for (Value value : mod.getAttribute()) {
                        ocFinalState.remove(value.getString());
                    }
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    ocFinalState = mod.getAttribute();
                }
            }
        }
        DefaultEntry attrs = new DefaultEntry(this.schemaManager, Dn.ROOT_DSE);
        attrs.put(ocFinalState);
        return this.getSubentryAdminRoles(attrs);
    }

    private void getOperationalModForReplace(boolean hasRole, AttributeType attributeType, Entry entry, Dn oldDn, Dn newDn, List<Modification> modifications) throws LdapInvalidAttributeValueException {
        String oldDnStr = oldDn.getNormName();
        String newDnStr = newDn.getNormName();
        if (hasRole) {
            Attribute operational = entry.get(attributeType).clone();
            if (operational == null) {
                operational = new DefaultAttribute(attributeType, newDnStr);
            } else {
                operational.remove(oldDnStr);
                operational.add(newDnStr);
            }
            modifications.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, operational));
        }
    }

    private List<Modification> getOperationalModsForReplace(Dn oldDn, Dn newDn, Subentry subentry, Entry entry) throws Exception {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        this.getOperationalModForReplace(subentry.isAccessControlAdminRole(), ACCESS_CONTROL_SUBENTRIES_AT, entry, oldDn, newDn, modifications);
        this.getOperationalModForReplace(subentry.isSchemaAdminRole(), SUBSCHEMA_SUBENTRY_AT, entry, oldDn, newDn, modifications);
        this.getOperationalModForReplace(subentry.isCollectiveAdminRole(), COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT, entry, oldDn, newDn, modifications);
        this.getOperationalModForReplace(subentry.isTriggersAdminRole(), TRIGGER_EXECUTION_SUBENTRIES_AT, entry, oldDn, newDn, modifications);
        return modifications;
    }

    private List<Attribute> getSubentryOperationalAttributes(Dn dn, Subentry subentry) throws LdapException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (subentry.isAccessControlAdminRole()) {
            DefaultAttribute accessControlSubentries = new DefaultAttribute(ACCESS_CONTROL_SUBENTRIES_AT, dn.getNormName());
            attributes.add(accessControlSubentries);
        }
        if (subentry.isSchemaAdminRole()) {
            DefaultAttribute subschemaSubentry = new DefaultAttribute(SUBSCHEMA_SUBENTRY_AT, dn.getNormName());
            attributes.add(subschemaSubentry);
        }
        if (subentry.isCollectiveAdminRole()) {
            DefaultAttribute collectiveAttributeSubentries = new DefaultAttribute(COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT, dn.getNormName());
            attributes.add(collectiveAttributeSubentries);
        }
        if (subentry.isTriggersAdminRole()) {
            DefaultAttribute tiggerExecutionSubentries = new DefaultAttribute(TRIGGER_EXECUTION_SUBENTRIES_AT, dn.getNormName());
            attributes.add(tiggerExecutionSubentries);
        }
        return attributes;
    }

    private List<Modification> getOperationalModsForRemove(Dn subentryDn, Entry candidate) throws LdapException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        String dn = subentryDn.getNormName();
        for (AttributeType operationalAttribute : SUBENTRY_OPATTRS) {
            Attribute opAttr = candidate.get(operationalAttribute);
            if (opAttr == null || !opAttr.contains(dn)) continue;
            DefaultAttribute attr = new DefaultAttribute(operationalAttribute, dn);
            modifications.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, attr));
        }
        return modifications;
    }

    private List<Modification> getOperationalModsForAdd(Entry entry, List<Attribute> operationalAttributes) throws LdapException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        for (Attribute operationalAttribute : operationalAttributes) {
            Attribute opAttrInEntry = entry.get(operationalAttribute.getAttributeType());
            if (opAttrInEntry != null && opAttrInEntry.size() > 0) {
                Attribute newOperationalAttribute = operationalAttribute.clone();
                for (Value value : opAttrInEntry) {
                    newOperationalAttribute.add(value);
                }
                modifications.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, newOperationalAttribute));
                continue;
            }
            modifications.add(new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, operationalAttribute));
        }
        return modifications;
    }

    private List<Modification> getModsOnEntryModification(Dn name, Entry oldEntry, Entry newEntry) throws LdapException {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        for (Dn subentryDn : this.subentryCache) {
            Attribute opAttr;
            ModificationOperation op;
            boolean isNewEntrySelected;
            Dn apDn = subentryDn.getParent();
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldEntrySelected = this.evaluator.evaluate(ss, apDn, name, oldEntry);
            if (isOldEntrySelected == (isNewEntrySelected = this.evaluator.evaluate(ss, apDn, name, newEntry))) continue;
            if (isOldEntrySelected && !isNewEntrySelected) {
                for (AttributeType operationalAttribute : SUBENTRY_OPATTRS) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    opAttr = oldEntry.get(operationalAttribute);
                    if (opAttr == null) continue;
                    opAttr = opAttr.clone();
                    opAttr.remove(subentryDn.getNormName());
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modList.add(new DefaultModification(op, opAttr));
                }
                continue;
            }
            if (!isNewEntrySelected || isOldEntrySelected) continue;
            for (AttributeType operationalAttribute : SUBENTRY_OPATTRS) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                opAttr = new DefaultAttribute(operationalAttribute);
                opAttr.add(subentryDn.getNormName());
                modList.add(new DefaultModification(op, opAttr));
            }
        }
        return modList;
    }

    private void setOperationalAttribute(Entry entry, Dn subentryDn, AttributeType opAttr) throws LdapException {
        Attribute operational = entry.get(opAttr);
        if (operational == null) {
            operational = new DefaultAttribute(opAttr);
            entry.put(operational);
        }
        operational.add(subentryDn.getNormName());
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        Dn dn = addContext.getDn();
        Entry entry = addContext.getEntry();
        if (entry.contains(OBJECT_CLASS_AT, "subentry")) {
            if (dn.isRootDSE() || this.isNamingContext(dn)) {
                throw new LdapOtherException("Cannot find an AdministrativePoint for " + dn);
            }
            Dn apDn = dn.getParent();
            this.checkAdministrativeRole(addContext, apDn);
            Subentry subentry = new Subentry();
            subentry.setAdministrativeRoles(this.getSubentryAdminRoles(entry));
            List<Attribute> operationalAttributes = this.getSubentryOperationalAttributes(dn, subentry);
            this.setSubtreeSpecification(subentry, entry);
            this.subentryCache.addSubentry(dn, subentry);
            next.add(addContext);
            Dn baseDn = apDn;
            baseDn = baseDn.add(subentry.getSubtreeSpecification().getBase());
            this.updateEntries(OperationEnum.ADD, addContext.getSession(), dn, apDn, subentry.getSubtreeSpecification(), baseDn, operationalAttributes);
            addContext.setEntry(entry);
        } else {
            for (Dn subentryDn : this.subentryCache) {
                Subentry subentry;
                SubtreeSpecification ss;
                Dn apDn = subentryDn.getParent();
                if (!dn.isDescendantOf(apDn) || !this.evaluator.evaluate(ss = (subentry = this.subentryCache.getSubentry(subentryDn)).getSubtreeSpecification(), apDn, dn, entry)) continue;
                if (subentry.isAccessControlAdminRole()) {
                    this.setOperationalAttribute(entry, subentryDn, ACCESS_CONTROL_SUBENTRIES_AT);
                }
                if (subentry.isSchemaAdminRole()) {
                    this.setOperationalAttribute(entry, subentryDn, SUBSCHEMA_SUBENTRY_AT);
                }
                if (subentry.isCollectiveAdminRole()) {
                    this.setOperationalAttribute(entry, subentryDn, COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT);
                }
                if (!subentry.isTriggersAdminRole()) continue;
                this.setOperationalAttribute(entry, subentryDn, TRIGGER_EXECUTION_SUBENTRIES_AT);
            }
            addContext.setEntry(entry);
            next.add(addContext);
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        Entry entry = deleteContext.getEntry();
        if (entry.contains(OBJECT_CLASS_AT, "subentry")) {
            Dn apDn;
            Subentry removedSubentry = this.subentryCache.getSubentry(dn);
            Dn baseDn = apDn = dn.getParent();
            baseDn = baseDn.add(removedSubentry.getSubtreeSpecification().getBase());
            this.updateEntries(OperationEnum.REMOVE, deleteContext.getSession(), dn, apDn, removedSubentry.getSubtreeSpecification(), baseDn, null);
            this.subentryCache.removeSubentry(dn);
            next.delete(deleteContext);
        } else {
            next.delete(deleteContext);
        }
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext listContext) throws LdapException {
        EntryFilteringCursor cursor = nextInterceptor.list(listContext);
        if (!this.isSubentryVisible(listContext)) {
            cursor.addEntryFilter(new HideSubentriesFilter());
        }
        return cursor;
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        Entry newEntry;
        List<Modification> subentriesOpAttrMods;
        boolean containsSubentryOC;
        Dn dn = modifyContext.getDn();
        List<Modification> modifications = modifyContext.getModItems();
        Entry entry = modifyContext.getEntry();
        boolean isSubtreeSpecificationModification = false;
        Modification subtreeMod = null;
        for (Modification mod : modifications) {
            if (!mod.getAttribute().getAttributeType().equals(SUBTREE_SPECIFICATION_AT)) continue;
            isSubtreeSpecificationModification = true;
            subtreeMod = mod;
            break;
        }
        if ((containsSubentryOC = entry.contains(OBJECT_CLASS_AT, "subentry")) && isSubtreeSpecificationModification) {
            Dn apName;
            SubtreeSpecification ssNew;
            Subentry subentry = this.subentryCache.removeSubentry(dn);
            SubtreeSpecification ssOld = subentry.getSubtreeSpecification();
            try {
                ssNew = this.ssParser.parse(subtreeMod.getAttribute().getString());
            }
            catch (Exception e) {
                String msg = I18n.err(I18n.ERR_71, new Object[0]);
                LOG.error(msg, e);
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
            }
            subentry.setSubtreeSpecification(ssNew);
            subentry.setAdministrativeRoles(this.getSubentryTypes(entry, modifications));
            this.subentryCache.addSubentry(dn, subentry);
            next.modify(modifyContext);
            Dn oldBaseDn = apName = dn.getParent();
            oldBaseDn = oldBaseDn.add(ssOld.getBase());
            PresenceNode filter = new PresenceNode(OBJECT_CLASS_AT);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(modifyContext.getSession(), oldBaseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn candidateDn = candidate.getDn();
                    if (!this.evaluator.evaluate(ssOld, apName, candidateDn, candidate)) continue;
                    this.nexus.modify(new ModifyOperationContext(modifyContext.getSession(), candidateDn, this.getOperationalModsForRemove(dn, candidate)));
                }
                subentries.close();
            }
            catch (Exception e) {
                throw new LdapOperationErrorException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
            subentry = this.subentryCache.getSubentry(dn);
            List<Attribute> operationalAttributes = this.getSubentryOperationalAttributes(dn, subentry);
            Dn newBaseDn = apName;
            newBaseDn = newBaseDn.add(ssNew.getBase());
            searchOperationContext = new SearchOperationContext(modifyContext.getSession(), newBaseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn candidateDn = candidate.getDn();
                    if (!this.evaluator.evaluate(ssNew, apName, candidateDn, candidate)) continue;
                    this.nexus.modify(new ModifyOperationContext(modifyContext.getSession(), candidateDn, this.getOperationalModsForAdd(candidate, operationalAttributes)));
                }
                subentries.close();
            }
            catch (Exception e) {
                throw new LdapOperationErrorException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        next.modify(modifyContext);
        if (!containsSubentryOC && (subentriesOpAttrMods = this.getModsOnEntryModification(dn, entry, newEntry = modifyContext.getAlteredEntry())).size() > 0) {
            this.nexus.modify(new ModifyOperationContext(modifyContext.getSession(), dn, subentriesOpAttrMods));
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        Dn oldDn = moveContext.getDn();
        Dn newSuperiorDn = moveContext.getNewSuperior();
        Entry entry = moveContext.getOriginalEntry();
        if (entry.contains(OBJECT_CLASS_AT, "subentry")) {
            Dn apName;
            this.checkAdministrativeRole(moveContext, newSuperiorDn);
            Subentry subentry = this.subentryCache.removeSubentry(oldDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            Dn baseDn = apName = oldDn.getParent();
            baseDn = baseDn.add(ss.getBase());
            Dn newName = newSuperiorDn;
            newName = newName.add(oldDn.getRdn());
            newName.apply(this.schemaManager);
            this.subentryCache.addSubentry(newName, subentry);
            next.move(moveContext);
            subentry = this.subentryCache.getSubentry(newName);
            PresenceNode filter = new PresenceNode(OBJECT_CLASS_AT);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(moveContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn dn = candidate.getDn();
                    dn.apply(this.schemaManager);
                    if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                    this.nexus.modify(new ModifyOperationContext(moveContext.getSession(), dn, this.getOperationalModsForReplace(oldDn, newName, subentry, candidate)));
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        if (this.hasAdministrativeDescendant(moveContext, oldDn)) {
            String msg = I18n.err(I18n.ERR_308, new Object[0]);
            LOG.warn(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        next.move(moveContext);
        Dn newDn = moveContext.getNewDn();
        List<Modification> mods = this.getModsOnEntryRdnChange(oldDn, newDn, entry);
        if (mods.size() > 0) {
            this.nexus.modify(new ModifyOperationContext(moveContext.getSession(), newDn, mods));
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
        Entry entry = moveAndRenameContext.getOriginalEntry();
        if (entry.contains(OBJECT_CLASS_AT, "subentry")) {
            Dn apName;
            Subentry subentry = this.subentryCache.removeSubentry(oldDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            Dn baseDn = apName = oldDn.getParent();
            baseDn = baseDn.add(ss.getBase());
            Dn newName = newSuperiorDn.getParent();
            newName = newName.add(moveAndRenameContext.getNewRdn());
            newName.apply(this.schemaManager);
            this.subentryCache.addSubentry(newName, subentry);
            next.moveAndRename(moveAndRenameContext);
            subentry = this.subentryCache.getSubentry(newName);
            PresenceNode filter = new PresenceNode(OBJECT_CLASS_AT);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(moveAndRenameContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn dn = candidate.getDn();
                    dn.apply(this.schemaManager);
                    if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                    this.nexus.modify(new ModifyOperationContext(moveAndRenameContext.getSession(), dn, this.getOperationalModsForReplace(oldDn, newName, subentry, candidate)));
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        if (this.hasAdministrativeDescendant(moveAndRenameContext, oldDn)) {
            String msg = I18n.err(I18n.ERR_308, new Object[0]);
            LOG.warn(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        next.moveAndRename(moveAndRenameContext);
        Dn newDn = moveAndRenameContext.getNewDn();
        List<Modification> mods = this.getModsOnEntryRdnChange(oldDn, newDn, entry);
        if (mods.size() > 0) {
            this.nexus.modify(new ModifyOperationContext(moveAndRenameContext.getSession(), newDn, mods));
        }
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        Dn oldDn = renameContext.getDn();
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        if (entry.contains(OBJECT_CLASS_AT, "subentry")) {
            Dn apName;
            Subentry subentry = this.subentryCache.removeSubentry(oldDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            Dn baseDn = apName = oldDn.getParent();
            baseDn = baseDn.add(ss.getBase());
            Dn newName = oldDn.getParent();
            newName = newName.add(renameContext.getNewRdn());
            newName.apply(this.schemaManager);
            this.subentryCache.addSubentry(newName, subentry);
            next.rename(renameContext);
            subentry = this.subentryCache.getSubentry(newName);
            PresenceNode filter = new PresenceNode(OBJECT_CLASS_AT);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(renameContext.getSession(), baseDn, filter, controls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor subentries = this.nexus.search(searchOperationContext);
            try {
                while (subentries.next()) {
                    Entry candidate = (Entry)subentries.get();
                    Dn dn = candidate.getDn();
                    dn.apply(this.schemaManager);
                    if (!this.evaluator.evaluate(ss, apName, dn, candidate)) continue;
                    this.nexus.modify(new ModifyOperationContext(renameContext.getSession(), dn, this.getOperationalModsForReplace(oldDn, newName, subentry, candidate)));
                }
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            finally {
                try {
                    subentries.close();
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        if (this.hasAdministrativeDescendant(renameContext, oldDn)) {
            String msg = I18n.err(I18n.ERR_308, new Object[0]);
            LOG.warn(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, msg);
        }
        next.rename(renameContext);
        Dn newName = renameContext.getNewDn();
        List<Modification> mods = this.getModsOnEntryRdnChange(oldDn, newName, entry);
        if (mods.size() > 0) {
            this.nexus.modify(new ModifyOperationContext(renameContext.getSession(), newName, mods));
        }
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = nextInterceptor.search(searchContext);
        if (searchContext.getScope() == SearchScope.OBJECT) {
            return cursor;
        }
        if (!this.isSubentryVisible(searchContext)) {
            cursor.addEntryFilter(new HideSubentriesFilter());
        } else {
            cursor.addEntryFilter(new HideEntriesFilter());
        }
        return cursor;
    }

    public Entry getSubentryAttributes(Dn dn, Entry entryAttrs) throws LdapException {
        DefaultEntry subentryAttrs = new DefaultEntry(this.schemaManager, dn);
        for (Dn subentryDn : this.subentryCache) {
            Attribute operational;
            Dn apDn = subentryDn.getParent();
            Subentry subentry = this.subentryCache.getSubentry(subentryDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            if (!this.evaluator.evaluate(ss, apDn, dn, entryAttrs)) continue;
            if (subentry.isAccessControlAdminRole()) {
                operational = subentryAttrs.get(ACCESS_CONTROL_SUBENTRIES_AT);
                if (operational == null) {
                    operational = new DefaultAttribute(ACCESS_CONTROL_SUBENTRIES_AT);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (subentry.isSchemaAdminRole()) {
                operational = subentryAttrs.get(SUBSCHEMA_SUBENTRY_AT);
                if (operational == null) {
                    operational = new DefaultAttribute(SUBSCHEMA_SUBENTRY_AT);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (subentry.isCollectiveAdminRole()) {
                operational = subentryAttrs.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT);
                if (operational == null) {
                    operational = new DefaultAttribute(COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (!subentry.isTriggersAdminRole()) continue;
            operational = subentryAttrs.get(TRIGGER_EXECUTION_SUBENTRIES_AT);
            if (operational == null) {
                operational = new DefaultAttribute(TRIGGER_EXECUTION_SUBENTRIES_AT);
                subentryAttrs.put(operational);
            }
            operational.add(subentryDn.getNormName());
        }
        return subentryAttrs;
    }

    private class HideEntriesFilter
    implements EntryFilter {
        private HideEntriesFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext searchContext, Entry entry) throws Exception {
            if (SubentryInterceptor.this.subentryCache.hasSubentry(entry.getDn())) {
                return true;
            }
            return entry.contains(OBJECT_CLASS_AT, "subentry");
        }
    }

    private class HideSubentriesFilter
    implements EntryFilter {
        private HideSubentriesFilter() {
        }

        @Override
        public boolean accept(SearchingOperationContext searchContext, Entry entry) throws Exception {
            if (SubentryInterceptor.this.subentryCache.hasSubentry(entry.getDn())) {
                return false;
            }
            return !entry.contains(OBJECT_CLASS_AT, "subentry");
        }
    }

    private static enum OperationEnum {
        ADD,
        REMOVE,
        REPLACE;

    }
}

