/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.SimpleNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class RefinementLeafEvaluator {
    private final SchemaManager schemaManager;
    private AttributeType OBJECT_CLASS_AT;

    public RefinementLeafEvaluator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.OBJECT_CLASS_AT = schemaManager.getAttributeType("objectClass");
    }

    public boolean evaluate(SimpleNode node, Attribute objectClasses) throws LdapException {
        if (node == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_295, new Object[0]));
        }
        if (!(node instanceof EqualityNode)) {
            throw new LdapException(I18n.err(I18n.ERR_301, node));
        }
        if (node.isSchemaAware() ? !node.getAttributeType().equals(this.OBJECT_CLASS_AT) : !node.getAttribute().equalsIgnoreCase("objectClass") && !node.getAttribute().equalsIgnoreCase("2.5.4.0")) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_302, node.getAttribute()));
        }
        if (null == objectClasses) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_303, new Object[0]));
        }
        if (!objectClasses.isInstanceOf(this.OBJECT_CLASS_AT)) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_304, new Object[0]));
        }
        String value = node.getValue().getString();
        if (objectClasses.contains(value)) {
            return true;
        }
        if (Character.isDigit(value.charAt(0))) {
            for (String objectClass : this.schemaManager.getGlobalOidRegistry().getNameSet(value)) {
                if (!objectClasses.contains(objectClass)) continue;
                return true;
            }
        }
        return false;
    }
}

