/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import java.util.ArrayList;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparatorSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(ComparatorSynchronizer.class);

    public ComparatorSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oid = this.getOid(entry);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            comparator.setSchemaName(schemaName);
            this.schemaManager.unregisterComparator(oid);
            this.schemaManager.add(comparator);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "Comparator");
        this.checkOidIsUniqueForComparator(entry);
        String schemaName = this.getSchemaName(dn);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && comparator.isEnabled()) {
            if (this.schemaManager.add(comparator)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_350, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The Comparator {} cannot be added in the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "Comparator");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The Comparator {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        LdapComparator<?> comparator = null;
        try {
            comparator = this.checkComparatorOidExists(entry);
        }
        catch (LdapSchemaViolationException lsve) {
            comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
            if (this.schemaManager.getRegistries().contains(comparator)) {
                this.schemaManager.getRegistries().dissociateFromSchema(comparator);
                return;
            }
            String msg = I18n.err(I18n.ERR_351, entry.getDn().getName());
            LOG.info(msg);
            throw new LdapSchemaViolationException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        ArrayList errors = new ArrayList();
        if (schema.isEnabled() && comparator.isEnabled()) {
            if (this.schemaManager.delete(comparator)) {
                LOG.debug("Deleted {} from the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_352, entry.getDn().getName(), Strings.listToString(errors));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The Comparator {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String oldOid = this.getOid(entry);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_353, oldOid));
        }
        String oid = newRdn.getNormValue().getString();
        this.checkOidIsUniqueForComparator(oid);
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.isSchemaEnabled(schemaName)) {
            Entry targetEntry = entry.clone();
            String newOid = newRdn.getNormValue().getString();
            this.checkOidIsUnique(newOid);
            targetEntry.put("m-oid", newOid);
            Dn newDn = targetEntry.getDn().getParent();
            newDn = newDn.add(newRdn);
            targetEntry.setDn(newDn);
            LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
            this.schemaManager.unregisterComparator(oldOid);
            this.schemaManager.add(comparator);
        }
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRdn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_353, oldOid));
        }
        String oid = newRdn.getNormValue().getString();
        this.checkOidIsUniqueForComparator(oid);
        String newSchemaName = this.getSchemaName(newParentName);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterComparator(oldOid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(comparator);
        }
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_354, oid));
        }
        String newSchemaName = this.getSchemaName(newParentName);
        LdapComparator<?> comparator = this.factory.getLdapComparator(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterComparator(oid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(comparator);
        }
    }

    private void checkOidIsUniqueForComparator(String oid) throws LdapSchemaViolationException {
        if (this.schemaManager.getComparatorRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_355, oid));
        }
    }

    private void checkOidIsUniqueForComparator(Entry entry) throws LdapException {
        String oid = this.getOid(entry);
        if (this.schemaManager.getComparatorRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_355, oid));
        }
    }

    protected LdapComparator<?> checkComparatorOidExists(Entry entry) throws LdapException {
        String oid = this.getOid(entry);
        if (this.schemaManager.getComparatorRegistry().contains(oid)) {
            return (LdapComparator)this.schemaManager.getComparatorRegistry().get(oid);
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_336, oid));
    }

    private void checkNewParent(Dn newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_357, new Object[0]));
        }
        Rdn rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_358, new Object[0]));
        }
        if (!rdn.getNormValue().getString().equalsIgnoreCase("comparators")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_359, new Object[0]));
        }
    }
}

