/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTypeSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeTypeSynchronizer.class);

    public AttributeTypeSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "AttributeType");
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(dn);
        AttributeType attributeType = this.factory.getAttributeType(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && attributeType.isEnabled()) {
            if (this.schemaManager.add(attributeType)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_345, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The AttributeType {} cannot be added in the disabled schema {}.", attributeType, (Object)schemaName);
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oid = this.getOid(entry);
        AttributeType at = this.factory.getAttributeType(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            if (this.schemaManager.getAttributeTypeRegistry().contains(oid)) {
                this.schemaManager.unregisterAttributeType(oid);
            }
            this.schemaManager.add(at);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "AttributeType");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The AttributeType {} cannot be removed from the disabled schema {}.", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        AttributeType attributeType = (AttributeType)this.checkOidExists(entry);
        if (schema.isEnabled() && attributeType.isEnabled()) {
            if (this.schemaManager.delete(attributeType)) {
                LOG.debug("Removed {} from the schema {}", attributeType, (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_346, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("Removed {} from the disabled schema {}", attributeType, (Object)schemaName);
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String schemaName = this.getSchemaName(entry.getDn());
        AttributeType oldAt = this.factory.getAttributeType(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        Dn newDn = targetEntry.getDn().getParent();
        newDn = newDn.add(newRdn);
        targetEntry.setDn(newDn);
        AttributeType at = this.factory.getAttributeType(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(oldAt.getOid())) {
                String msg = I18n.err(I18n.ERR_347, entry.getDn().getName(), newDn);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
            this.schemaManager.unregisterAttributeType(oldAt.getOid());
            this.schemaManager.add(at);
        } else {
            this.unregisterOids(oldAt);
            this.registerOids(at);
        }
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkParent(newParentName, this.schemaManager, "AttributeType");
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        AttributeType oldAt = this.factory.getAttributeType(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        Entry targetEntry = entry.clone();
        String newOid = newRn.getNormValue().getString();
        targetEntry.put("m-oid", newOid);
        this.checkOidIsUnique(newOid);
        AttributeType newAt = this.factory.getAttributeType(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (!this.isSchemaLoaded(oldSchemaName)) {
            String msg = I18n.err(I18n.ERR_348, oldSchemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        if (!this.isSchemaLoaded(newSchemaName)) {
            String msg = I18n.err(I18n.ERR_349, newSchemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        this.deleteFromSchema(oldAt, oldSchemaName);
        this.addToSchema(newAt, newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterAttributeType(oldAt.getOid());
        } else {
            this.unregisterOids(oldAt);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(newAt);
        } else {
            this.registerOids(newAt);
        }
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkParent(newParentName, this.schemaManager, "AttributeType");
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        AttributeType oldAt = this.factory.getAttributeType(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        AttributeType newAt = this.factory.getAttributeType(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (!this.isSchemaLoaded(oldSchemaName)) {
            String msg = "Cannot move a schemaObject from a not loaded schema " + oldSchemaName;
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        if (!this.isSchemaLoaded(newSchemaName)) {
            String msg = I18n.err(I18n.ERR_349, newSchemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        this.deleteFromSchema(oldAt, oldSchemaName);
        this.addToSchema(newAt, newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterAttributeType(oldAt.getOid());
        } else {
            this.unregisterOids(oldAt);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(newAt);
        } else {
            this.registerOids(newAt);
        }
    }
}

