/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import jdbm.btree.BTree;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.ArrayTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainerCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyBTreeCursor;
import org.apache.directory.shared.ldap.model.cursor.AbstractTupleCursor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DupsCursor<K, V>
extends AbstractTupleCursor<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DupsCursor.class.getSimpleName());
    private final JdbmTable<K, V> table;
    private final DupsContainerCursor<K, V> containerCursor;
    private final Tuple<K, DupsContainer<V>> containerTuple = new Tuple();
    private Cursor<V> dupsCursor;
    private final Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public DupsCursor(JdbmTable<K, V> table) throws Exception {
        this.table = table;
        this.containerCursor = new DupsContainerCursor<K, V>(table);
        LOG.debug("Created on table {}", table);
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    @Override
    public void beforeKey(K key) throws Exception {
        this.beforeValue(key, null);
    }

    @Override
    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        this.containerCursor.before(new Tuple<K, Object>(key, null));
        if (this.containerCursor.next()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor<V>(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            if (value == null) {
                return;
            }
            if (this.table.getKeyComparator().compare(this.containerTuple.getKey(), key) == 0) {
                this.dupsCursor.before(value);
            }
            return;
        }
        this.clearValue();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
    }

    @Override
    public void afterKey(K key) throws Exception {
        this.afterValue(key, null);
    }

    @Override
    public void afterValue(K key, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (value == null) {
            this.containerCursor.after(new Tuple<K, Object>(key, null));
        } else {
            this.containerCursor.before(new Tuple<K, Object>(key, null));
        }
        if (this.containerCursor.next()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor<V>(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            if (value == null) {
                return;
            }
            if (this.table.getKeyComparator().compare(this.containerTuple.getKey(), key) == 0) {
                this.dupsCursor.after(value);
            }
            return;
        }
        this.clearValue();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
    }

    @Override
    public void before(Tuple<K, V> element) throws Exception {
        this.beforeValue(element.getKey(), element.getValue());
    }

    @Override
    public void after(Tuple<K, V> element) throws Exception {
        this.afterValue(element.getKey(), element.getValue());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.clearValue();
        this.containerCursor.beforeFirst();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
        this.dupsCursor = null;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.clearValue();
        this.containerCursor.afterLast();
        this.containerTuple.setKey(null);
        this.containerTuple.setValue(null);
        this.dupsCursor = null;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        this.clearValue();
        this.dupsCursor = null;
        if (this.containerCursor.first()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (this.containerTuple.getValue().isArrayTree()) {
                this.dupsCursor = new ArrayTreeCursor<V>(values.getArrayTree());
            } else {
                BTree bt = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(bt, this.table.getValueComparator());
            }
            this.dupsCursor.first();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.containerTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        this.clearValue();
        this.dupsCursor = null;
        if (this.containerCursor.last()) {
            this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
            DupsContainer<V> values = this.containerTuple.getValue();
            if (values.isArrayTree()) {
                ArrayTree<V> set = values.getArrayTree();
                this.dupsCursor = new ArrayTreeCursor<V>(set);
            } else {
                BTree tree = this.table.getBTree(values.getBTreeRedirect());
                this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
            }
            this.dupsCursor.last();
            this.valueAvailable = true;
            this.returnedTuple.setKey(this.containerTuple.getKey());
            this.returnedTuple.setValue(this.dupsCursor.get());
            return true;
        }
        return false;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (null == this.dupsCursor || !this.dupsCursor.previous()) {
            if (this.containerCursor.previous()) {
                this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
                DupsContainer<V> values = this.containerTuple.getValue();
                if (values.isArrayTree()) {
                    ArrayTree<V> set = values.getArrayTree();
                    this.dupsCursor = new ArrayTreeCursor<V>(set);
                } else {
                    BTree tree = this.table.getBTree(values.getBTreeRedirect());
                    this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
                }
                this.dupsCursor.afterLast();
                this.dupsCursor.previous();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.containerTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (null == this.dupsCursor || !this.dupsCursor.next()) {
            if (this.containerCursor.next()) {
                this.containerTuple.setBoth((Tuple<K, DupsContainer<V>>)this.containerCursor.get());
                DupsContainer<V> values = this.containerTuple.getValue();
                if (values.isArrayTree()) {
                    ArrayTree<V> set = values.getArrayTree();
                    this.dupsCursor = new ArrayTreeCursor<V>(set);
                } else {
                    BTree tree = this.table.getBTree(values.getBTreeRedirect());
                    this.dupsCursor = new KeyBTreeCursor(tree, this.table.getValueComparator());
                }
                this.dupsCursor.beforeFirst();
                this.dupsCursor.next();
            } else {
                this.dupsCursor = null;
                return false;
            }
        }
        this.returnedTuple.setKey(this.containerTuple.getKey());
        this.returnedTuple.setValue(this.dupsCursor.get());
        this.valueAvailable = true;
        return true;
    }

    @Override
    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (!this.valueAvailable) {
            throw new InvalidCursorPositionException();
        }
        return this.returnedTuple;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.containerCursor.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        super.close(cause);
        this.containerCursor.close(cause);
    }
}

