/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.journal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.journal.JournalStore;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;

public class DefaultJournalStore
implements JournalStore {
    private File workingDirectory;
    private String fileName;
    private File journal;
    private Writer writer;

    @Override
    public void destroy() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public void init(DirectoryService service) throws Exception {
        if (this.workingDirectory == null) {
            this.workingDirectory = service.getInstanceLayout().getLogDirectory();
        }
        if (this.fileName == null) {
            this.fileName = "journal.ldif";
        }
        this.journal = new File(this.workingDirectory, this.fileName);
        this.writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.journal, true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean log(LdapPrincipal principal, long revision, LdifEntry forward) {
        Writer writer = this.writer;
        synchronized (writer) {
            try {
                this.writer.write("# principal: ");
                this.writer.write(principal.getName());
                this.writer.write(10);
                this.writer.write("# timestamp: ");
                this.writer.write(Long.toString(System.currentTimeMillis()));
                this.writer.write(10);
                this.writer.write("# revision: ");
                this.writer.write(Long.toString(revision));
                this.writer.write("\n");
                this.writer.write(LdifUtils.convertToLdif(forward, 80));
                this.writer.flush();
            }
            catch (LdapException ne) {
                return false;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ack(long revision) {
        Writer writer = this.writer;
        synchronized (writer) {
            try {
                this.writer.write("# ack-revision: ");
                this.writer.write(Long.toString(revision));
                this.writer.write("\n\n");
                this.writer.flush();
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nack(long revision) {
        Writer writer = this.writer;
        synchronized (writer) {
            try {
                this.writer.write("# nack-revision: ");
                this.writer.write(Long.toString(revision));
                this.writer.write("\n\n");
                this.writer.flush();
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void sync() throws Exception {
    }

    @Override
    public long getCurrentRevision() {
        return 0L;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void setWorkingDirectory(String workingDirectoryName) {
        this.workingDirectory = new File(workingDirectoryName);
    }
}

