/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerDirContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.ldap.model.entry.AbstractValue;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.util.JndiUtils;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.NotImplementedException;

public class ServerLdapContext
extends ServerDirContext
implements LdapContext {
    public ServerLdapContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        super(service, env);
    }

    public ServerLdapContext(DirectoryService service, LdapPrincipal principal, Name dn) throws Exception {
        super(service, principal, dn);
    }

    public ServerLdapContext(DirectoryService service, CoreSession session, Name bindDn) throws Exception {
        super(service, session, bindDn);
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) {
        throw new NotImplementedException();
    }

    @Override
    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), JndiUtils.toName(this.getDn()));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ctx.setRequestControls(requestControls);
        return ctx;
    }

    @Override
    public void reconnect(Control[] connCtls) throws NamingException {
        this.connectControls = connCtls;
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return this.connectControls;
    }

    @Override
    public void setRequestControls(Control[] requestControls) throws NamingException {
        this.requestControls = requestControls;
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return this.requestControls;
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.responseControls;
    }

    public boolean compare(Dn name, String oid, Object value) throws NamingException {
        AbstractValue val;
        block13: {
            val = null;
            AttributeType attributeType = null;
            try {
                attributeType = this.getService().getSchemaManager().lookupAttributeTypeRegistry(oid);
            }
            catch (LdapException le) {
                throw new InvalidAttributeIdentifierException(le.getMessage());
            }
            try {
                if (attributeType.getSyntax().isHumanReadable()) {
                    if (value instanceof String) {
                        val = new StringValue(attributeType, (String)value);
                        break block13;
                    }
                    if (value instanceof byte[]) {
                        val = new StringValue(attributeType, Strings.utf8ToString((byte[])value));
                        break block13;
                    }
                    throw new NamingException(I18n.err(I18n.ERR_309, oid));
                }
                if (value instanceof String) {
                    val = new BinaryValue(attributeType, Strings.getBytesUtf8((String)value));
                    break block13;
                }
                if (value instanceof byte[]) {
                    val = new BinaryValue(attributeType, (byte[])value);
                    break block13;
                }
                throw new NamingException(I18n.err(I18n.ERR_309, oid));
            }
            catch (LdapInvalidAttributeValueException liave) {
                throw new NamingException(I18n.err(I18n.ERR_309, oid));
            }
        }
        CompareOperationContext opCtx = new CompareOperationContext(this.getSession(), name, oid, val);
        try {
            opCtx.addRequestControls(JndiUtils.fromJndiControls(this.getDirectoryService().getLdapCodecService(), this.requestControls));
        }
        catch (DecoderException e1) {
            throw new NamingException(I18n.err(I18n.ERR_309, oid));
        }
        this.injectReferralControl(opCtx);
        boolean result = false;
        try {
            result = super.getDirectoryService().getOperationManager().compare(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        this.responseControls = this.getResponseControls();
        this.requestControls = EMPTY_CONTROLS;
        return result;
    }

    public void ldapUnbind() throws NamingException {
        UnbindOperationContext opCtx = new UnbindOperationContext(this.getSession());
        try {
            opCtx.addRequestControls(JndiUtils.fromJndiControls(this.getDirectoryService().getLdapCodecService(), this.requestControls));
        }
        catch (DecoderException e1) {
            throw new NamingException(I18n.err(I18n.ERR_309, "unbind encoder exception"));
        }
        try {
            super.getDirectoryService().getOperationManager().unbind(opCtx);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        try {
            this.responseControls = JndiUtils.toJndiControls(this.getDirectoryService().getLdapCodecService(), opCtx.getResponseControls());
        }
        catch (EncoderException e) {
            throw new NamingException(I18n.err(I18n.ERR_309, "unbind encoder exception"));
        }
        this.requestControls = EMPTY_CONTROLS;
    }

    @Override
    public ServerContext getRootContext() throws NamingException {
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.getService(), this.getSession().getEffectivePrincipal(), (Name)new LdapName(""));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }
}

