/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;

public class SearchOperationContext
extends SearchingOperationContext {
    private ExprNode filter;

    public SearchOperationContext(CoreSession session) {
        super(session);
    }

    public SearchOperationContext(CoreSession session, SearchRequest searchRequest) throws LdapException {
        super(session);
        this.dn = searchRequest.getBase();
        this.filter = searchRequest.getFilter();
        this.abandoned = searchRequest.isAbandoned();
        this.aliasDerefMode = searchRequest.getDerefAliases();
        this.requestControls = searchRequest.getControls();
        this.scope = searchRequest.getScope();
        this.sizeLimit = searchRequest.getSizeLimit();
        this.timeLimit = searchRequest.getTimeLimit();
        this.typesOnly = searchRequest.getTypesOnly();
        List<String> ats = searchRequest.getAttributes();
        if (ats.isEmpty()) {
            ats = new ArrayList<String>();
            ats.add("*");
            ats = Collections.unmodifiableList(ats);
        }
        this.setReturningAttributes(ats);
        this.throwReferral = !this.requestControls.containsKey("2.16.840.1.113730.3.4.2");
    }

    public SearchOperationContext(CoreSession session, Dn dn, ExprNode filter, SearchControls searchControls) throws LdapException {
        super(session, dn);
        this.filter = filter;
        this.scope = SearchScope.getSearchScope(searchControls.getSearchScope());
        this.timeLimit = searchControls.getTimeLimit();
        this.sizeLimit = searchControls.getCountLimit();
        this.typesOnly = searchControls.getReturningObjFlag();
        if (searchControls.getReturningAttributes() != null) {
            this.setReturningAttributes(searchControls.getReturningAttributes());
        } else {
            this.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        }
    }

    public SearchOperationContext(CoreSession session, Dn dn, SearchScope scope, ExprNode filter, Set<AttributeTypeOptions> returningAttributes) {
        super(session, dn, returningAttributes);
        super.setScope(scope);
        this.filter = filter;
    }

    public boolean hasManageDsaItControl() {
        return super.hasRequestControl("2.16.840.1.113730.3.4.2");
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }

    @Override
    public String toString() {
        return "SearchContext for Dn '" + this.getDn().getName() + "', filter :'" + this.filter + "'";
    }

    @Override
    public String getName() {
        return MessageTypeEnum.SEARCH_REQUEST.name();
    }
}

