/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;

public class MoveAndRenameOperationContext
extends RenameOperationContext {
    private Dn newSuperiorDn;

    public MoveAndRenameOperationContext(CoreSession session) {
        super(session);
    }

    public MoveAndRenameOperationContext(CoreSession session, Dn oldDn, Dn newSuperiorDn, Rdn newRdn, boolean delOldRdn) {
        super(session, oldDn, newRdn, delOldRdn);
        this.newSuperiorDn = newSuperiorDn;
        try {
            this.newDn = newSuperiorDn.add(newRdn);
        }
        catch (LdapInvalidDnException lide) {
            throw new IllegalArgumentException(lide.getMessage(), lide);
        }
    }

    public MoveAndRenameOperationContext(CoreSession session, ModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest);
        this.newSuperiorDn = modifyDnRequest.getNewSuperior();
        if (this.newSuperiorDn == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_325, modifyDnRequest));
        }
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
        try {
            this.newDn = this.newSuperiorDn.add(this.newRdn).apply(session.getDirectoryService().getSchemaManager());
        }
        catch (LdapInvalidDnException lide) {
            throw new IllegalStateException(I18n.err(I18n.ERR_325, modifyDnRequest));
        }
    }

    public Dn getNewSuperiorDn() {
        return this.newSuperiorDn;
    }

    public void setNewSuperiorDn(Dn newSuperiorDn) {
        this.newSuperiorDn = newSuperiorDn;
    }

    @Override
    public String toString() {
        return "ReplaceContext for old Dn '" + this.getDn().getName() + "' : " + this.newDn;
    }
}

