/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.FreeLogicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;
import jdbm.recman.TranslationPage;
import org.apache.directory.server.i18n.I18n;

final class LogicalRowIdManager {
    private RecordFile recordFile;
    private PageManager pageManager;
    private FreeLogicalRowIdPageManager freeman;

    LogicalRowIdManager(PageManager pageManager) throws IOException {
        this.recordFile = pageManager.getRecordFile();
        this.pageManager = pageManager;
        this.freeman = new FreeLogicalRowIdPageManager(pageManager);
    }

    Location insert(Location loc) throws IOException {
        Location retval = this.freeman.get();
        if (retval == null) {
            long firstPage = this.pageManager.allocate((short)2);
            short curOffset = 18;
            for (int i = 0; i < 407; ++i) {
                this.freeman.put(new Location(firstPage, curOffset));
                curOffset = (short)(curOffset + 10);
            }
            retval = this.freeman.get();
            if (retval == null) {
                throw new Error(I18n.err(I18n.ERR_545, new Object[0]));
            }
        }
        this.update(retval, loc);
        return retval;
    }

    void delete(Location rowid) throws IOException {
        this.freeman.put(rowid);
    }

    void update(Location rowid, Location loc) throws IOException {
        TranslationPage xlatPage = TranslationPage.getTranslationPageView(this.recordFile.get(rowid.getBlock()));
        PhysicalRowId physid = xlatPage.get(rowid.getOffset());
        physid.setBlock(loc.getBlock());
        physid.setOffset(loc.getOffset());
        this.recordFile.release(rowid.getBlock(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location fetch(Location rowid) throws IOException {
        TranslationPage xlatPage = TranslationPage.getTranslationPageView(this.recordFile.get(rowid.getBlock()));
        try {
            Location retval;
            Location location = retval = new Location(xlatPage.get(rowid.getOffset()));
            return location;
        }
        finally {
            this.recordFile.release(rowid.getBlock(), false);
        }
    }
}

