/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdbm.ActionRecordManager;
import jdbm.RecordManager;
import jdbm.btree.BPage;
import jdbm.helper.ActionContext;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.helper.WrappedRuntimeException;
import org.apache.directory.server.i18n.I18n;

public class BTree<K, V>
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_SIZE = 16;
    protected transient RecordManager recordManager;
    private transient long recordId;
    Comparator<K> comparator;
    protected Serializer keySerializer;
    protected Serializer valueSerializer;
    int bTreeHeight;
    private long rootId;
    protected int pageSize;
    protected AtomicInteger nbEntries;
    private transient BPage<K, V> bpageSerializer;
    private transient boolean isActionCapable;
    private transient Lock bigLock = new ReentrantLock();
    private transient MetaRoot metaRoot = new MetaRoot();

    public BTree() {
    }

    public BTree(RecordManager recman, Comparator<K> comparator) throws IOException {
        this.createInstance(recman, comparator, null, null, 16);
    }

    public BTree(RecordManager recman, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        this.createInstance(recman, comparator, keySerializer, valueSerializer, 16);
    }

    public BTree(RecordManager recman, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer, int pageSize) throws IOException {
        this.createInstance(recman, comparator, keySerializer, valueSerializer, pageSize);
    }

    private void createInstance(RecordManager recordManager, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer, int pageSize) throws IOException {
        if (recordManager == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_517, new Object[0]));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_518, new Object[0]));
        }
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_519, new Object[0]));
        }
        if ((pageSize & 1) != 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_522, new Object[0]));
        }
        this.recordManager = recordManager;
        this.comparator = comparator;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.pageSize = pageSize;
        this.bpageSerializer = new BPage();
        this.bpageSerializer.btree = this;
        this.nbEntries = new AtomicInteger(0);
        this.isActionCapable = recordManager instanceof ActionRecordManager;
        boolean abortedAction = false;
        ActionContext context = this.beginAction(false, "createInstance");
        try {
            this.recordId = recordManager.insert(this);
            this.updateMetaRoot(this.rootId, this.bTreeHeight);
        }
        catch (IOException e) {
            abortedAction = true;
            this.abortAction(context);
            throw e;
        }
        finally {
            if (!abortedAction) {
                this.endAction(context);
            }
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize = (pageSize & 1) != 0 ? 16 : pageSize;
    }

    public BTree<K, V> load(RecordManager recman, long recid) throws IOException {
        BTree btree = null;
        boolean abortedAction = false;
        ActionContext context = this.beginAction(false, "load");
        try {
            btree = (BTree)recman.fetch(recid);
            btree.recordId = recid;
            btree.recordManager = recman;
            btree.bpageSerializer = new BPage();
            btree.bpageSerializer.btree = btree;
            btree.updateMetaRoot(btree.rootId, btree.bTreeHeight);
        }
        catch (IOException e) {
            abortedAction = true;
            this.abortAction(context);
            throw e;
        }
        finally {
            if (!abortedAction) {
                this.endAction(context);
            }
        }
        return btree;
    }

    public Object insert(K key, V value, boolean replace) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_523, new Object[0]));
        }
        if (value == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_524, new Object[0]));
        }
        boolean abortedAction = false;
        ActionContext context = this.beginAction(false, "insert");
        if (!this.isActionCapable) {
            this.bigLock.lock();
        }
        try {
            BPage<Object, Object> rootPage = this.getRoot();
            if (rootPage == null) {
                rootPage = new BPage<K, V>(this, key, value);
                this.rootId = rootPage.getRecordId();
                this.bTreeHeight = 1;
                this.nbEntries.set(1);
                this.recordManager.update(this.recordId, this);
                this.updateMetaRoot(this.rootId, this.bTreeHeight);
                Object var7_8 = null;
                return var7_8;
            }
            BPage.InsertResult<K, V> insert = rootPage.insert(this.bTreeHeight, key, value, replace);
            if (insert.pageNewCopy != null) {
                rootPage = insert.pageNewCopy;
            }
            boolean dirty = false;
            if (insert.overflow != null) {
                rootPage = new BPage(this, rootPage, insert.overflow);
                this.rootId = rootPage.getRecordId();
                ++this.bTreeHeight;
                dirty = true;
                this.updateMetaRoot(this.rootId, this.bTreeHeight);
            }
            if (insert.existing == null) {
                this.nbEntries.getAndIncrement();
                dirty = true;
            }
            if (dirty) {
                this.recordManager.update(this.recordId, this);
            }
            Object v = insert.existing;
            return v;
        }
        catch (IOException e) {
            abortedAction = true;
            this.abortAction(context);
            throw e;
        }
        finally {
            if (!abortedAction) {
                this.endAction(context);
            }
            if (!this.isActionCapable) {
                this.bigLock.unlock();
            }
        }
    }

    public V remove(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_523, new Object[0]));
        }
        boolean abortedAction = false;
        ActionContext context = this.beginAction(false, "remove");
        if (!this.isActionCapable) {
            this.bigLock.lock();
        }
        try {
            BPage<K, V> rootPage = this.getRoot();
            if (rootPage == null) {
                V v = null;
                return v;
            }
            boolean dirty = false;
            BPage.RemoveResult<K, V> remove = rootPage.remove(this.bTreeHeight, key);
            if (remove.pageNewCopy != null) {
                rootPage = remove.pageNewCopy;
            }
            if (remove.underflow && rootPage.isEmpty()) {
                --this.bTreeHeight;
                dirty = true;
                this.recordManager.delete(this.rootId);
                this.rootId = this.bTreeHeight == 0 ? 0L : rootPage.childBPage(this.pageSize - 1).getRecordId();
                this.updateMetaRoot(this.rootId, this.bTreeHeight);
            }
            if (remove.value != null) {
                this.nbEntries.getAndDecrement();
                dirty = true;
            }
            if (dirty) {
                this.recordManager.update(this.recordId, this);
            }
            Object v = remove.value;
            return v;
        }
        catch (IOException e) {
            abortedAction = true;
            this.abortAction(context);
            throw e;
        }
        finally {
            if (!abortedAction) {
                this.endAction(context);
            }
            if (!this.isActionCapable) {
                this.bigLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V find(K key) throws IOException {
        TupleBrowser<Object, Object> browser = null;
        Tuple<Object, Object> tuple = null;
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_523, new Object[0]));
        }
        if (!this.isActionCapable) {
            this.bigLock.lock();
        }
        try {
            tuple = new Tuple<Object, Object>(null, null);
            browser = this.browse(key);
            if (browser.getNext(tuple)) {
                if (this.comparator.compare(key, tuple.getKey()) != 0) {
                    V v = null;
                    return v;
                }
                V v = this.copyValue(tuple.getValue());
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            if (browser != null) {
                browser.close();
            }
            if (!this.isActionCapable) {
                this.bigLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<K, V> findGreaterOrEqual(K key) throws IOException {
        TupleBrowser<Object, Object> browser = null;
        if (key == null) {
            return null;
        }
        if (!this.isActionCapable) {
            this.bigLock.lock();
        }
        Tuple<Object, Object> tuple = new Tuple<Object, Object>(null, null);
        try {
            browser = this.browse(key);
            if (browser.getNext(tuple)) {
                tuple.setValue(this.copyValue(tuple.getValue()));
                Tuple<Object, Object> tuple2 = tuple;
                return tuple2;
            }
            Tuple<K, V> tuple3 = null;
            return tuple3;
        }
        finally {
            if (browser != null) {
                browser.close();
            }
            if (!this.isActionCapable) {
                this.bigLock.unlock();
            }
        }
    }

    public TupleBrowser<K, V> browse() throws IOException {
        TupleBrowser<K, V> browser = null;
        ActionContext context = this.beginAction(true, "browse");
        try {
            MetaRoot meta = this.getMetaRoot();
            BPage<K, V> rootPage = this.getRoot(meta);
            if (rootPage == null) {
                this.endAction(context);
                return new EmptyBrowser(){};
            }
            browser = rootPage.findFirst(context);
        }
        catch (IOException e) {
            this.abortAction(context);
            throw e;
        }
        this.unsetAsCurrentAction(context);
        return browser;
    }

    public TupleBrowser<K, V> browse(K key) throws IOException {
        TupleBrowser<K, V> browser = null;
        ActionContext context = this.beginAction(true, "browse key");
        try {
            MetaRoot meta = this.getMetaRoot();
            BPage<K, V> rootPage = this.getRoot(meta);
            if (rootPage == null) {
                this.endAction(context);
                return new EmptyBrowser(){};
            }
            browser = rootPage.find(meta.treeHeight, key, context);
        }
        catch (IOException e) {
            this.abortAction(context);
            throw e;
        }
        this.unsetAsCurrentAction(context);
        return browser;
    }

    public int size() {
        return this.nbEntries.get();
    }

    public long getRecordId() {
        return this.recordId;
    }

    BPage<K, V> getRoot() throws IOException {
        assert (this.rootId == this.metaRoot.rootID) : "Stale root id " + this.rootId + " " + this.metaRoot.rootID;
        if (this.rootId == 0L) {
            return null;
        }
        BPage root = (BPage)this.recordManager.fetch(this.rootId, this.bpageSerializer);
        root.setRecordId(this.rootId);
        root.btree = this;
        return root;
    }

    BPage<K, V> getRoot(MetaRoot meta) throws IOException {
        if (meta.rootID == 0L) {
            return null;
        }
        BPage root = (BPage)this.recordManager.fetch(meta.rootID, this.bpageSerializer);
        root.setRecordId(meta.rootID);
        root.btree = this;
        return root;
    }

    MetaRoot getMetaRoot() throws IOException {
        if (this.isActionCapable) {
            return (MetaRoot)this.recordManager.fetch(-this.recordId);
        }
        return this.metaRoot;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.comparator = (Comparator)in.readObject();
        this.keySerializer = (Serializer)in.readObject();
        this.valueSerializer = (Serializer)in.readObject();
        this.bTreeHeight = in.readInt();
        this.rootId = in.readLong();
        this.pageSize = in.readInt();
        this.nbEntries = new AtomicInteger(in.readInt());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.comparator);
        out.writeObject(this.keySerializer);
        out.writeObject(this.valueSerializer);
        out.writeInt(this.bTreeHeight);
        out.writeLong(this.rootId);
        out.writeInt(this.pageSize);
        out.writeInt(this.nbEntries.get());
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    void setAsCurrentAction(ActionContext context) {
        if (context != null) {
            assert (this.isActionCapable);
            ((ActionRecordManager)this.recordManager).setCurrentActionContext(context);
        }
    }

    void unsetAsCurrentAction(ActionContext context) {
        if (context != null) {
            assert (this.isActionCapable);
            ((ActionRecordManager)this.recordManager).unsetCurrentActionContext(context);
        }
    }

    ActionContext beginAction(boolean readOnly, String whoStarted) {
        ActionContext context = null;
        if (this.isActionCapable) {
            context = ((ActionRecordManager)this.recordManager).beginAction(readOnly, whoStarted);
        }
        return context;
    }

    void endAction(ActionContext context) {
        if (context != null) {
            assert (this.isActionCapable);
            ((ActionRecordManager)this.recordManager).endAction(context);
        }
    }

    void abortAction(ActionContext context) {
        if (context != null) {
            assert (this.isActionCapable);
            ((ActionRecordManager)this.recordManager).abortAction(context);
        }
    }

    BPage<K, V> copyOnWrite(BPage<K, V> page) throws IOException {
        return page.copyOnWrite();
    }

    private MetaRoot copyOnWrite(MetaRoot oldMetaRoot) {
        MetaRoot newMetaRoot = new MetaRoot();
        newMetaRoot.rootID = oldMetaRoot.rootID;
        newMetaRoot.treeHeight = oldMetaRoot.treeHeight;
        return newMetaRoot;
    }

    private void updateMetaRoot(long newRootId, int newTreeHeight) throws IOException {
        this.metaRoot = this.copyOnWrite(this.metaRoot);
        this.metaRoot.rootID = newRootId;
        this.metaRoot.treeHeight = newTreeHeight;
        if (this.isActionCapable) {
            this.recordManager.update(-this.recordId, this.metaRoot);
        }
    }

    V copyValue(V value) throws IOException {
        Object valueCopy = null;
        if (value == null) {
            return null;
        }
        if (this.valueSerializer != null) {
            byte[] array = this.valueSerializer.serialize(value);
            valueCopy = this.valueSerializer.deserialize(array);
        } else {
            ObjectOutputStream out = null;
            ObjectInputStream in = null;
            ByteArrayOutputStream bout = null;
            ByteArrayInputStream bin = null;
            try {
                bout = new ByteArrayOutputStream();
                out = new ObjectOutputStream(bout);
                out.writeObject(value);
                out.flush();
                byte[] arr = bout.toByteArray();
                bin = new ByteArrayInputStream(arr);
                in = new ObjectInputStream(bin);
                valueCopy = in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new WrappedRuntimeException(e);
            }
            finally {
                if (bout != null) {
                    bout.close();
                }
                if (out != null) {
                    out.close();
                }
                if (bin != null) {
                    bin.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        return (V)valueCopy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BTree");
        sb.append("(height:").append(this.bTreeHeight);
        sb.append(", pageSize:").append(this.pageSize);
        sb.append(", nbEntries:").append(this.nbEntries);
        sb.append(", rootId:").append(this.rootId);
        sb.append(", comparator:");
        if (this.comparator == null) {
            sb.append("null");
        } else {
            sb.append(this.comparator.getClass().getSimpleName());
        }
        sb.append(", keySerializer:");
        if (this.keySerializer == null) {
            sb.append("null");
        } else {
            sb.append(this.keySerializer.getClass().getSimpleName());
        }
        sb.append(", valueSerializer:");
        if (this.valueSerializer == null) {
            sb.append("null");
        } else {
            sb.append(this.valueSerializer.getClass().getSimpleName());
        }
        sb.append(")\n");
        return sb.toString();
    }

    class MetaRoot {
        long rootID;
        int treeHeight;

        MetaRoot() {
        }
    }

    class EmptyBrowser
    extends TupleBrowser<K, V> {
        EmptyBrowser() {
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) {
            return false;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) {
            return false;
        }
    }
}

