/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotParentIdAndRdnSerializer
extends AbstractElementSerializer<ParentIdAndRdn> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MavibotParentIdAndRdnSerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static SchemaManager schemaManager;
    private static Comparator<ParentIdAndRdn> comparator;

    public MavibotParentIdAndRdnSerializer() {
        super(comparator);
    }

    @Override
    public byte[] serialize(ParentIdAndRdn parentIdAndRdn) {
        try {
            for (int bufferSize = 1024; bufferSize < Integer.MAX_VALUE; bufferSize += bufferSize) {
                byte[] buffer = new byte[bufferSize];
                try {
                    int pos = 0;
                    Rdn[] rdns = parentIdAndRdn.getRdns();
                    if (rdns == null || rdns.length == 0) {
                        pos = Serialize.serialize(0, buffer, pos);
                    } else {
                        pos = Serialize.serialize(rdns.length, buffer, pos);
                        for (Rdn rdn : rdns) {
                            pos = rdn.serialize(buffer, pos);
                        }
                    }
                    String parentId = parentIdAndRdn.getParentId();
                    byte[] parentIdBytes = Strings.getBytesUtf8(parentId);
                    pos = Serialize.serialize(parentIdBytes, buffer, pos);
                    pos = Serialize.serialize(parentIdAndRdn.getNbChildren(), buffer, pos);
                    pos = Serialize.serialize(parentIdAndRdn.getNbDescendants(), buffer, pos);
                    if (IS_DEBUG) {
                        LOG.debug(">------------------------------------------------");
                        LOG.debug("Serialize " + parentIdAndRdn);
                    }
                    byte[] result = new byte[pos];
                    System.arraycopy(buffer, 0, result, 0, pos);
                    return result;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    continue;
                }
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ParentIdAndRdn deserialize(BufferHandler bufferHandler) throws IOException {
        return this.deserialize(ByteBuffer.wrap(bufferHandler.getBuffer()));
    }

    @Override
    public ParentIdAndRdn deserialize(ByteBuffer buffer) throws IOException {
        ParentIdAndRdn parentIdAndRdn = this.fromBytes(buffer.array(), buffer.position());
        return parentIdAndRdn;
    }

    @Override
    public int compare(ParentIdAndRdn type1, ParentIdAndRdn type2) {
        return type1.compareTo(type2);
    }

    @Override
    public Comparator<ParentIdAndRdn> getComparator() {
        return comparator;
    }

    public static void setSchemaManager(SchemaManager schemaManager) {
        MavibotParentIdAndRdnSerializer.schemaManager = schemaManager;
    }

    @Override
    public ParentIdAndRdn fromBytes(byte[] buffer) throws IOException {
        return this.fromBytes(buffer, 0);
    }

    @Override
    public ParentIdAndRdn fromBytes(byte[] buffer, int pos) throws IOException {
        try {
            ParentIdAndRdn parentIdAndRdn = new ParentIdAndRdn();
            int nbRdns = Serialize.deserializeInt(buffer, pos);
            pos += 4;
            if (nbRdns == 0) {
                parentIdAndRdn.setRdns(new Rdn[0]);
            } else {
                Rdn[] rdns = new Rdn[nbRdns];
                for (int i = 0; i < nbRdns; ++i) {
                    Rdn rdn = new Rdn(schemaManager);
                    pos = rdn.deserialize(buffer, pos);
                    rdns[i] = rdn;
                }
                parentIdAndRdn.setRdns(rdns);
            }
            byte[] uuidBytes = Serialize.deserializeBytes(buffer, pos);
            String uuid = Strings.utf8ToString(uuidBytes);
            parentIdAndRdn.setParentId(uuid);
            int nbChildren = Serialize.deserializeInt(buffer, pos += 4 + uuidBytes.length);
            int nbDescendants = Serialize.deserializeInt(buffer, pos += 4);
            pos += 4;
            parentIdAndRdn.setNbChildren(nbChildren);
            parentIdAndRdn.setNbDescendants(nbDescendants);
            return parentIdAndRdn;
        }
        catch (LdapInvalidAttributeValueException cnfe) {
            LOG.error(I18n.err(I18n.ERR_134, cnfe.getLocalizedMessage()));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }

    @Override
    public Class<?> getType() {
        return ParentIdAndRdn.class;
    }

    static {
        comparator = new Comparator<ParentIdAndRdn>(){

            @Override
            public int compare(ParentIdAndRdn rdn1, ParentIdAndRdn rdn2) {
                return rdn1.compareTo(rdn2);
            }
        };
    }
}

