/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;

public class NotNode
extends BranchNode {
    public NotNode(List<ExprNode> childList) {
        super(AssertionType.NOT);
        if (childList != null) {
            this.setChildren(childList);
        }
    }

    public NotNode(ExprNode child) {
        super(AssertionType.NOT);
        if (child != null) {
            this.addNode(child);
        }
    }

    public NotNode() {
        this((ExprNode)null);
    }

    @Override
    public void addNode(ExprNode node) {
        if (this.children == null || this.children.size() >= 1) {
            throw new IllegalStateException(I18n.err(I18n.ERR_04159, new Object[0]));
        }
        this.children.add(node);
    }

    @Override
    public void addNodeToHead(ExprNode node) {
        if (this.children.size() >= 1) {
            throw new IllegalStateException(I18n.err(I18n.ERR_04159, new Object[0]));
        }
        this.children.add(node);
    }

    @Override
    public void setChildren(List<ExprNode> childList) {
        if (childList != null && childList.size() > 1) {
            throw new IllegalStateException(I18n.err(I18n.ERR_04159, new Object[0]));
        }
        this.children = childList;
    }

    public AssertionType getOperator() {
        return AssertionType.NOT;
    }

    public boolean isDisjunction() {
        return false;
    }

    public boolean isConjunction() {
        return false;
    }

    public boolean isNegation() {
        return true;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        buf.append("not: ");
        ((ExprNode)this.children.get(0)).printRefinementToBuffer(buf);
        return buf;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(!");
        buf.append(super.toString());
        buf.append(this.getFirstChild());
        buf.append(')');
        return buf.toString();
    }
}

