/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.search.ConnectorFilter;
import org.apache.directory.api.ldap.codec.search.Filter;

public class AndFilter
extends ConnectorFilter {
    public AndFilter(int tlvId) {
        super(tlvId);
    }

    public AndFilter() {
    }

    public List<Filter> getAndFilter() {
        return this.filterSet;
    }

    @Override
    public int computeLength() {
        this.filtersLength = super.computeLength();
        return 1 + TLV.getNbBytes(this.filtersLength) + this.filtersLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        try {
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes(this.filtersLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]), boe);
        }
        super.encode(buffer);
        return buffer;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('&').append(super.toString());
        return sb.toString();
    }
}

