/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedEntrySerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SortedEntrySerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static SchemaManager schemaManager;

    @Override
    public byte[] serialize(Object obj) throws IOException {
        return this.serialize((Entry)obj);
    }

    @Override
    public Object deserialize(byte[] serialized) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serialized));
        try {
            DefaultEntry entry = new DefaultEntry(schemaManager);
            Dn dn = new Dn(schemaManager);
            dn.readExternal(in);
            entry.setDn(dn);
            int nbAttributes = in.readInt();
            for (int i = 0; i < nbAttributes; ++i) {
                String oid = in.readUTF();
                try {
                    AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(oid);
                    DefaultAttribute attribute = new DefaultAttribute(attributeType);
                    attribute.readExternal(in);
                    entry.add(attribute);
                    continue;
                }
                catch (LdapException ne) {
                    throw new ClassNotFoundException(ne.getMessage(), ne);
                }
            }
            return entry;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err(I18n.ERR_134, cnfe.getLocalizedMessage()));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }

    public byte[] serialize(Entry entry) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            Dn dn = entry.getDn();
            dn.writeExternal(out);
            out.writeInt(entry.getAttributes().size());
            for (Attribute attribute : entry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                String oid = attributeType.getOid();
                out.writeUTF(oid);
                attribute.writeExternal(out);
            }
            out.flush();
            if (IS_DEBUG) {
                LOG.debug(">------------------------------------------------");
                LOG.debug("Serialize " + entry);
            }
            byte[] bytes = baos.toByteArray();
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setSchemaManager(SchemaManager schemaManager) {
        SortedEntrySerializer.schemaManager = schemaManager;
    }
}

