/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SyncRequestValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncInfoValue.SynchronizationInfoEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateTypeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueDecorator;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueDecorator;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueDecorator;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.IntermediateResponseImpl;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.api.ldap.model.message.SearchResultReferenceImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequest;
import org.apache.directory.api.ldap.model.message.controls.SortRequestControlImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.event.DirectoryListenerAdapter;
import org.apache.directory.server.core.api.event.EventService;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.SearchAbandonListener;
import org.apache.directory.server.ldap.handlers.SearchTimeLimitingMonitor;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.provider.ReplConsumerManager;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLogJanitor;
import org.apache.directory.server.ldap.replication.provider.ReplicaJournalCursor;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.ldap.replication.provider.SyncReplSearchListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplRequestHandler
implements ReplicationRequestHandler {
    private static final Logger PROVIDER_LOG = LoggerFactory.getLogger(Loggers.PROVIDER_LOG.getName());
    private boolean initialized = false;
    private DirectoryService dirService;
    protected LdapServer ldapServer;
    private static AttributeType OBJECT_CLASS_AT;
    private AttributeType CSN_AT;
    private Map<Integer, ReplicaEventLog> replicaLogMap = new ConcurrentHashMap<Integer, ReplicaEventLog>();
    private File syncReplData;
    private AtomicInteger replicaCount = new AtomicInteger(0);
    private ReplConsumerManager replicaUtil;
    private ConsumerLogEntryChangeListener cledListener;
    private ReplicaEventLogJanitor logJanitor;
    private AttributeType REPL_LOG_MAX_IDLE_AT;
    private AttributeType REPL_LOG_PURGE_THRESHOLD_COUNT_AT;

    @Override
    public void start(LdapServer server) {
        if (this.initialized) {
            PROVIDER_LOG.warn("syncrepl provider was already initialized");
            return;
        }
        try {
            PROVIDER_LOG.debug("initializing the syncrepl provider");
            this.ldapServer = server;
            this.dirService = server.getDirectoryService();
            this.CSN_AT = this.dirService.getSchemaManager().lookupAttributeTypeRegistry("entryCSN");
            OBJECT_CLASS_AT = this.dirService.getSchemaManager().lookupAttributeTypeRegistry("objectClass");
            this.REPL_LOG_MAX_IDLE_AT = this.dirService.getSchemaManager().lookupAttributeTypeRegistry("ads-replLogMaxIdle");
            this.REPL_LOG_PURGE_THRESHOLD_COUNT_AT = this.dirService.getSchemaManager().lookupAttributeTypeRegistry("ads-replLogPurgeThresholdCount");
            this.syncReplData = this.dirService.getInstanceLayout().getReplDirectory();
            if (!this.syncReplData.exists() && !this.syncReplData.mkdirs()) {
                throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, this.syncReplData));
            }
            this.replicaUtil = new ReplConsumerManager(this.dirService);
            this.loadReplicaInfo();
            this.logJanitor = new ReplicaEventLogJanitor(this.dirService, this.replicaLogMap);
            this.logJanitor.start();
            this.registerPersistentSearches();
            this.cledListener = new ConsumerLogEntryChangeListener();
            NotificationCriteria criteria = new NotificationCriteria();
            criteria.setBase(new Dn(this.dirService.getSchemaManager(), "ou=consumers,ou=system"));
            criteria.setEventMask(EventType.DELETE);
            this.dirService.getEventService().addListener(this.cledListener, criteria);
            CountDownLatch latch = new CountDownLatch(1);
            Thread consumerInfoUpdateThread = new Thread(this.createConsumerInfoUpdateTask(latch));
            consumerInfoUpdateThread.setDaemon(true);
            consumerInfoUpdateThread.start();
            boolean threadInitDone = latch.await(5L, TimeUnit.MINUTES);
            if (!threadInitDone) {
                PROVIDER_LOG.error("The consumer replica thread has not been initialized in time");
                throw new RuntimeException("Cannot initialize the Provider replica listener");
            }
            this.initialized = true;
            PROVIDER_LOG.debug("syncrepl provider initialized successfully");
        }
        catch (Exception e) {
            PROVIDER_LOG.error("Failed to initialize the log files required by the syncrepl provider", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        EventService evtSrv = this.dirService.getEventService();
        evtSrv.removeListener(this.cledListener);
        this.logJanitor.stopCleaning();
        this.logJanitor.interrupt();
        for (ReplicaEventLog log : this.replicaLogMap.values()) {
            try {
                PROVIDER_LOG.debug("Stopping the logging for replica ", (Object)log.getId());
                evtSrv.removeListener(log.getPersistentListener());
                log.stop();
            }
            catch (Exception e) {
                PROVIDER_LOG.error("Failed to close the event log {}", (Object)log.getId(), (Object)e);
            }
        }
        this.initialized = false;
    }

    @Override
    public void handleSyncRequest(LdapSession session, SearchRequest request) throws LdapException {
        PROVIDER_LOG.debug("Received a Syncrepl request : {} from {}", (Object)request, (Object)session);
        try {
            SyncRequestValue syncControl;
            byte[] cookieBytes;
            if (!request.getAttributes().contains("+")) {
                request.addAttributes("+");
            }
            if ((cookieBytes = (syncControl = (SyncRequestValue)request.getControls().get("1.3.6.1.4.1.4203.1.9.1.1")).getCookie()) == null) {
                PROVIDER_LOG.debug("Received a replication request with no cookie");
                this.doInitialRefresh(session, request);
            } else {
                String cookieString = Strings.utf8ToString(cookieBytes);
                PROVIDER_LOG.debug("Received a replication request {} with a cookie '{}'", (Object)request, (Object)cookieString);
                if (!LdapProtocolUtils.isValidCookie(cookieString)) {
                    PROVIDER_LOG.error("received an invalid cookie {} from the consumer with session {}", (Object)cookieString, (Object)session);
                    this.sendESyncRefreshRequired(session, request);
                } else {
                    ReplicaEventLog clientMsgLog = this.getReplicaEventLog(cookieString);
                    if (clientMsgLog == null) {
                        PROVIDER_LOG.debug("received a valid cookie {} but there is no event log associated with this replica", (Object)cookieString);
                        this.sendESyncRefreshRequired(session, request);
                    } else {
                        String consumerCsn = LdapProtocolUtils.getCsn(cookieString);
                        this.doContentUpdate(session, request, clientMsgLog, consumerCsn);
                    }
                }
            }
        }
        catch (Exception e) {
            PROVIDER_LOG.error("Failed to handle the syncrepl request", e);
            throw new LdapException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContentFromLog(LdapSession session, SearchRequest req, ReplicaEventLog clientMsgLog, String fromCsn) throws Exception {
        String lastSentCsn = fromCsn;
        PROVIDER_LOG.debug("Processing the log for replica {}", (Object)clientMsgLog.getId());
        try (ReplicaJournalCursor cursor = clientMsgLog.getCursor(fromCsn);){
            while (cursor.next()) {
                ReplicaEventMessage replicaEventMessage = cursor.get();
                Entry entry = replicaEventMessage.getEntry();
                PROVIDER_LOG.debug("Read message from the queue {}", (Object)entry);
                lastSentCsn = entry.get(this.CSN_AT).getString();
                ChangeType event = replicaEventMessage.getChangeType();
                SyncStateTypeEnum syncStateType = null;
                switch (event) {
                    case ADD: {
                        syncStateType = SyncStateTypeEnum.ADD;
                        break;
                    }
                    case MODIFY: {
                        syncStateType = SyncStateTypeEnum.MODIFY;
                        break;
                    }
                    case MODDN: {
                        syncStateType = SyncStateTypeEnum.MODDN;
                        break;
                    }
                    case DELETE: {
                        syncStateType = SyncStateTypeEnum.DELETE;
                    }
                }
                this.sendSearchResultEntry(session, req, entry, syncStateType);
                clientMsgLog.setLastSentCsn(lastSentCsn);
                PROVIDER_LOG.debug("The latest entry sent to the consumer {} has this CSN : {}", (Object)clientMsgLog.getId(), (Object)lastSentCsn);
            }
            PROVIDER_LOG.debug("All pending modifciations for replica {} processed", (Object)clientMsgLog.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doContentUpdate(LdapSession session, SearchRequest req, ReplicaEventLog replicaLog, String consumerCsn) throws Exception {
        ReplicaEventLog replicaEventLog = replicaLog;
        synchronized (replicaEventLog) {
            boolean refreshNPersist = this.isRefreshNPersist(req);
            if (refreshNPersist) {
                SyncReplSearchListener handler = replicaLog.getPersistentListener();
                handler.setSearchRequest(req);
                handler.setSession(session);
            }
            this.sendContentFromLog(session, req, replicaLog, consumerCsn);
            String lastSentCsn = replicaLog.getLastSentCsn();
            byte[] cookie = LdapProtocolUtils.createCookie(replicaLog.getId(), lastSentCsn);
            if (refreshNPersist) {
                IntermediateResponseImpl intermResp = new IntermediateResponseImpl(req.getMessageId());
                intermResp.setResponseName("1.3.6.1.4.1.4203.1.9.1.4");
                SyncInfoValueDecorator syncInfo = new SyncInfoValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService(), SynchronizationInfoEnum.NEW_COOKIE);
                syncInfo.setCookie(cookie);
                intermResp.setResponseValue(syncInfo.getValue());
                PROVIDER_LOG.debug("Sent the intermediate response to the {} consumer, {}", (Object)replicaLog.getId(), (Object)intermResp);
                session.getIoSession().write(intermResp);
                replicaLog.getPersistentListener().setPushInRealTime(refreshNPersist);
            } else {
                SearchResultDone searchDoneResp = (SearchResultDone)req.getResultResponse();
                searchDoneResp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
                SyncDoneValueDecorator syncDone = new SyncDoneValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
                syncDone.setCookie(cookie);
                searchDoneResp.addControl(syncDone);
                PROVIDER_LOG.debug("Send a SearchResultDone response to the {} consumer", (Object)replicaLog.getId(), (Object)searchDoneResp);
                session.getIoSession().write(searchDoneResp);
            }
        }
    }

    private void doInitialRefresh(LdapSession session, SearchRequest request) throws Exception {
        PROVIDER_LOG.debug("Starting an initial refresh");
        SortRequest ctrl = (SortRequest)request.getControl("1.2.840.113556.1.4.473");
        if (ctrl != null) {
            PROVIDER_LOG.warn("Removing the received sort control from the syncrepl search request during initial refresh");
            request.removeControl(ctrl);
        }
        PROVIDER_LOG.debug("Adding sort control to sort the entries by entryDn attribute to preserve order of insertion");
        SortKey sk = new SortKey("entryDN");
        sk.setMatchingRuleId("2.5.13.1");
        sk.setReverseOrder(true);
        ctrl = new SortRequestControlImpl();
        ctrl.addSortKey(sk);
        request.addControl(ctrl);
        String originalFilter = request.getFilter().toString();
        InetSocketAddress address = (InetSocketAddress)session.getIoSession().getRemoteAddress();
        String hostName = address.getAddress().getHostName();
        ExprNode modifiedFilter = this.modifyFilter(session, request);
        Partition partition = this.dirService.getPartitionNexus().getPartition(request.getBase());
        String contextCsn = partition.getContextCsn();
        boolean refreshNPersist = this.isRefreshNPersist(request);
        ReplicaEventLog replicaLog = this.createReplicaEventLog(hostName, originalFilter);
        replicaLog.setRefreshNPersist(refreshNPersist);
        StringValue contexCsnValue = new StringValue(contextCsn);
        GreaterEqNode<String> csnGeNode = new GreaterEqNode<String>(this.CSN_AT, contexCsnValue);
        AndNode postInitContentFilter = new AndNode(modifiedFilter, csnGeNode);
        request.setFilter(postInitContentFilter);
        PROVIDER_LOG.debug("Starting the replicaLog {}", (Object)replicaLog);
        SyncReplSearchListener replicationListener = new SyncReplSearchListener(session, request, replicaLog, false);
        replicaLog.setPersistentListener(replicationListener);
        NotificationCriteria criteria = new NotificationCriteria();
        criteria.setAliasDerefMode(request.getDerefAliases());
        criteria.setBase(request.getBase());
        criteria.setFilter(request.getFilter());
        criteria.setScope(request.getScope());
        criteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
        replicaLog.setSearchCriteria(criteria);
        this.dirService.getEventService().addListener(replicationListener, criteria);
        LessEqNode<String> csnNode = new LessEqNode<String>(this.CSN_AT, contexCsnValue);
        AndNode initialContentFilter = new AndNode(modifiedFilter, csnNode);
        request.setFilter(initialContentFilter);
        SearchResultDone searchDoneResp = this.doSimpleSearch(session, request, replicaLog);
        if (searchDoneResp.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS) {
            if (replicaLog.getLastSentCsn() == null) {
                replicaLog.setLastSentCsn(contextCsn);
            }
            if (refreshNPersist) {
                PROVIDER_LOG.debug("Refresh&Persist requested : send the data being modified since the initial refresh");
                this.sendContentFromLog(session, request, replicaLog, contextCsn);
                byte[] cookie = LdapProtocolUtils.createCookie(replicaLog.getId(), replicaLog.getLastSentCsn());
                IntermediateResponseImpl intermResp = new IntermediateResponseImpl(request.getMessageId());
                intermResp.setResponseName("1.3.6.1.4.1.4203.1.9.1.4");
                SyncInfoValueDecorator syncInfo = new SyncInfoValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService(), SynchronizationInfoEnum.NEW_COOKIE);
                syncInfo.setCookie(cookie);
                intermResp.setResponseValue(syncInfo.getValue());
                PROVIDER_LOG.info("Sending the intermediate response to consumer {}, {}", (Object)replicaLog, (Object)syncInfo);
                session.getIoSession().write(intermResp);
                replicationListener.setPushInRealTime(refreshNPersist);
                PROVIDER_LOG.debug("e waiting for any modification for {}", (Object)replicaLog);
            } else {
                PROVIDER_LOG.debug("RefreshOnly requested");
                byte[] cookie = LdapProtocolUtils.createCookie(replicaLog.getId(), contextCsn);
                SyncDoneValueDecorator syncDone = new SyncDoneValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
                syncDone.setCookie(cookie);
                searchDoneResp.addControl(syncDone);
                PROVIDER_LOG.info("Sending the searchResultDone response to consumer {}, {}", (Object)replicaLog, (Object)searchDoneResp);
                session.getIoSession().write(searchDoneResp);
            }
        } else {
            PROVIDER_LOG.warn("initial content refresh didn't succeed due to {}", (Object)searchDoneResp.getLdapResult().getResultCode());
            replicaLog.stop();
            replicaLog = null;
            this.dirService.getEventService().removeListener(replicationListener);
            return;
        }
        this.replicaUtil.addConsumerEntry(replicaLog);
        this.replicaLogMap.put(replicaLog.getId(), replicaLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResultDone doSimpleSearch(LdapSession session, SearchRequest req, ReplicaEventLog replicaLog) throws Exception {
        PROVIDER_LOG.debug("Simple Search {} for {}", (Object)req, (Object)session);
        SearchResultDone searchDoneResp = (SearchResultDone)req.getResultResponse();
        LdapResult ldapResult = searchDoneResp.getLdapResult();
        Cursor<Entry> cursor = session.getCoreSession().search(req);
        cursor.beforeFirst();
        try {
            long serverLimit = this.getServerSizeLimit(session, req);
            long requestLimit = req.getSizeLimit() == 0L ? Long.MAX_VALUE : req.getSizeLimit();
            req.addAbandonListener(new SearchAbandonListener(this.ldapServer, cursor));
            this.setTimeLimitsOnCursor(req, session, cursor);
            PROVIDER_LOG.debug("search operation requested size limit {}, server size limit {}", (Object)requestLimit, (Object)serverLimit);
            long sizeLimit = Math.min(requestLimit, serverLimit);
            this.readResults(session, req, ldapResult, cursor, sizeLimit, replicaLog);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    PROVIDER_LOG.error(I18n.err(I18n.ERR_168, new Object[0]), e);
                }
            }
        }
        PROVIDER_LOG.debug("Search done");
        return searchDoneResp;
    }

    private void readResults(LdapSession session, SearchRequest req, LdapResult ldapResult, Cursor<Entry> cursor, long sizeLimit, ReplicaEventLog replicaLog) throws Exception {
        long count;
        for (count = 0L; count < sizeLimit && cursor.next(); ++count) {
            if (session.getIoSession().isClosing()) {
                PROVIDER_LOG.debug("Request terminated for message {}, the client has closed the session", (Object)req.getMessageId());
                break;
            }
            if (req.isAbandoned()) {
                PROVIDER_LOG.debug("Request terminated by an AbandonRequest for message {}", (Object)req.getMessageId());
                break;
            }
            Entry entry = cursor.get();
            this.sendSearchResultEntry(session, req, entry, SyncStateTypeEnum.ADD);
            String lastSentCsn = entry.get(this.CSN_AT).getString();
            replicaLog.setLastSentCsn(lastSentCsn);
        }
        PROVIDER_LOG.debug("Sent {} entries for {}", (Object)count, (Object)replicaLog);
        ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        if (count >= sizeLimit && cursor.next()) {
            cursor.previous();
            ldapResult.setResultCode(ResultCodeEnum.SIZE_LIMIT_EXCEEDED);
        }
    }

    private void sendSearchResultEntry(LdapSession session, SearchRequest req, Entry entry, SyncStateTypeEnum syncStateType) throws Exception {
        Attribute uuid = entry.get("entryUUID");
        SyncStateValueDecorator syncStateControl = new SyncStateValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
        syncStateControl.setSyncStateType(syncStateType);
        syncStateControl.setEntryUUID(Strings.uuidToBytes(uuid.getString()));
        if (syncStateType == SyncStateTypeEnum.DELETE) {
            entry.clear();
            entry.add(uuid);
        }
        Response resp = this.generateResponse(session, req, entry);
        resp.addControl(syncStateControl);
        PROVIDER_LOG.debug("Sending the entry:\n {}", (Object)resp);
        session.getIoSession().write(resp);
    }

    private Response generateResponse(LdapSession session, SearchRequest req, Entry entry) throws Exception {
        Attribute ref = entry.get("ref");
        boolean hasManageDsaItControl = req.getControls().containsKey("2.16.840.1.113730.3.4.2");
        if (ref != null && !hasManageDsaItControl) {
            SearchResultReferenceImpl respRef = new SearchResultReferenceImpl(req.getMessageId());
            respRef.setReferral(new ReferralImpl());
            for (Value val : ref) {
                String url = val.getString();
                if (!url.startsWith("ldap")) {
                    respRef.getReferral().addLdapUrl(url);
                }
                LdapUrl ldapUrl = null;
                try {
                    ldapUrl = new LdapUrl(url);
                    ldapUrl.setForceScopeRendering(true);
                }
                catch (LdapURLEncodingException e) {
                    PROVIDER_LOG.error(I18n.err(I18n.ERR_165, url, entry));
                }
                switch (req.getScope()) {
                    case SUBTREE: {
                        ldapUrl.setScope(SearchScope.SUBTREE.getScope());
                        break;
                    }
                    case ONELEVEL: {
                        ldapUrl.setScope(SearchScope.OBJECT.getScope());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(I18n.err(I18n.ERR_686, new Object[0]));
                    }
                }
                respRef.getReferral().addLdapUrl(ldapUrl.toString());
            }
            return respRef;
        }
        SearchResultEntryImpl respEntry = new SearchResultEntryImpl(req.getMessageId());
        respEntry.setEntry(entry);
        respEntry.setObjectName(entry.getDn());
        return respEntry;
    }

    private long getServerSizeLimit(LdapSession session, SearchRequest request) {
        if (session.getCoreSession().isAnAdministrator()) {
            if (request.getSizeLimit() == 0L) {
                return Long.MAX_VALUE;
            }
            return request.getSizeLimit();
        }
        if (this.ldapServer.getMaxSizeLimit() == 0L) {
            return Long.MAX_VALUE;
        }
        return this.ldapServer.getMaxSizeLimit();
    }

    private void setTimeLimitsOnCursor(SearchRequest req, LdapSession session, Cursor<Entry> cursor) {
        if (session.getCoreSession().isAnAdministrator() && req.getTimeLimit() == 0) {
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() == 0 && req.getTimeLimit() == 0) {
            return;
        }
        if (req.getTimeLimit() == 0) {
            cursor.setClosureMonitor(new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        if (this.ldapServer.getMaxTimeLimit() >= req.getTimeLimit()) {
            cursor.setClosureMonitor(new SearchTimeLimitingMonitor(req.getTimeLimit(), TimeUnit.SECONDS));
            return;
        }
        cursor.setClosureMonitor(new SearchTimeLimitingMonitor(this.ldapServer.getMaxTimeLimit(), TimeUnit.SECONDS));
    }

    public ExprNode modifyFilter(LdapSession session, SearchRequest req) throws Exception {
        boolean isOcPresenceFilter = false;
        if (req.getFilter() instanceof PresenceNode) {
            PresenceNode presenceNode = (PresenceNode)req.getFilter();
            AttributeType at = session.getCoreSession().getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry(presenceNode.getAttribute());
            if (at.getOid().equals("2.5.4.0")) {
                isOcPresenceFilter = true;
            }
        }
        ExprNode filter = req.getFilter();
        if (!req.hasControl("2.16.840.1.113730.3.4.2") && !isOcPresenceFilter) {
            filter = new OrNode(req.getFilter(), this.newIsReferralEqualityNode(session));
        }
        return filter;
    }

    public ReplicaEventLogJanitor getLogJanitor() {
        return this.logJanitor;
    }

    public Map<Integer, ReplicaEventLog> getReplicaLogMap() {
        return this.replicaLogMap;
    }

    private EqualityNode<String> newIsReferralEqualityNode(LdapSession session) throws Exception {
        EqualityNode<String> ocIsReferral = new EqualityNode<String>("objectClass", new StringValue(OBJECT_CLASS_AT, "referral"));
        return ocIsReferral;
    }

    private void storeReplicaInfo() {
        try {
            for (Map.Entry<Integer, ReplicaEventLog> e : this.replicaLogMap.entrySet()) {
                ReplicaEventLog replica = e.getValue();
                if (!replica.isDirty()) continue;
                PROVIDER_LOG.debug("updating the details of replica {}", (Object)replica);
                this.replicaUtil.updateReplicaLastSentCsn(replica);
                replica.setDirty(false);
            }
        }
        catch (Exception e) {
            PROVIDER_LOG.error("Failed to store the replica information", e);
        }
    }

    private void loadReplicaInfo() {
        try {
            List<ReplicaEventLog> eventLogs = this.replicaUtil.getReplicaEventLogs();
            HashSet<String> eventLogNames = new HashSet<String>();
            if (!eventLogs.isEmpty()) {
                for (ReplicaEventLog replica : eventLogs) {
                    PROVIDER_LOG.debug("initializing the replica log from {}", (Object)replica.getId());
                    this.replicaLogMap.put(replica.getId(), replica);
                    eventLogNames.add(replica.getName());
                    if (this.replicaCount.get() >= replica.getId()) continue;
                    this.replicaCount.set(replica.getId());
                }
            } else {
                PROVIDER_LOG.debug("no replica logs found to initialize");
            }
            for (File f : this.getAllReplJournalNames()) {
                if (eventLogNames.contains(f.getName())) continue;
                f.delete();
                PROVIDER_LOG.info("removed unused replication event log {}", (Object)f);
            }
        }
        catch (Exception e) {
            PROVIDER_LOG.error("Failed to load the replica information", e);
        }
    }

    private void registerPersistentSearches() throws Exception {
        for (Map.Entry<Integer, ReplicaEventLog> e : this.replicaLogMap.entrySet()) {
            ReplicaEventLog log = e.getValue();
            if (log.getSearchCriteria() != null) {
                PROVIDER_LOG.debug("registering persistent search for the replica {}", (Object)log.getId());
                SyncReplSearchListener handler = new SyncReplSearchListener(null, null, log, false);
                log.setPersistentListener(handler);
                this.dirService.getEventService().addListener(handler, log.getSearchCriteria());
                continue;
            }
            PROVIDER_LOG.warn("invalid persistent search criteria {} for the replica {}", (Object)log.getSearchCriteria(), (Object)log.getId());
        }
    }

    private Runnable createConsumerInfoUpdateTask(final CountDownLatch latch) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    SyncReplRequestHandler.this.storeReplicaInfo();
                    try {
                        latch.countDown();
                        Thread.sleep(10000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        PROVIDER_LOG.warn("thread storing the replica information was interrupted", e);
                        continue;
                    }
                    break;
                }
            }
        };
        return task;
    }

    private ReplicaEventLog getReplicaEventLog(String cookieString) throws Exception {
        ReplicaEventLog replicaLog = null;
        if (LdapProtocolUtils.isValidCookie(cookieString)) {
            int clientId = LdapProtocolUtils.getReplicaId(cookieString);
            replicaLog = this.replicaLogMap.get(clientId);
        }
        return replicaLog;
    }

    private ReplicaEventLog createReplicaEventLog(String hostName, String filter) throws Exception {
        int replicaId = this.replicaCount.incrementAndGet();
        PROVIDER_LOG.debug("creating a new event log for the replica with id {}", (Object)replicaId);
        ReplicaEventLog replicaLog = new ReplicaEventLog(this.dirService, replicaId);
        replicaLog.setHostName(hostName);
        replicaLog.setSearchFilter(filter);
        return replicaLog;
    }

    private void sendESyncRefreshRequired(LdapSession session, SearchRequest req) throws Exception {
        SearchResultDone searchDoneResp = (SearchResultDone)req.getResultResponse();
        searchDoneResp.getLdapResult().setResultCode(ResultCodeEnum.E_SYNC_REFRESH_REQUIRED);
        SyncDoneValueDecorator syncDone = new SyncDoneValueDecorator(this.ldapServer.getDirectoryService().getLdapCodecService());
        searchDoneResp.addControl(syncDone);
        session.getIoSession().write(searchDoneResp);
    }

    private boolean isRefreshNPersist(SearchRequest req) {
        SyncRequestValue control = (SyncRequestValue)req.getControls().get("1.3.6.1.4.1.4203.1.9.1.1");
        return control.getMode() == SynchronizationModeEnum.REFRESH_AND_PERSIST;
    }

    private File[] getAllReplJournalNames() {
        File replDir = this.dirService.getInstanceLayout().getReplDirectory();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("REPL_EVENT_LOG.");
            }
        };
        return replDir.listFiles(filter);
    }

    private class ConsumerLogEntryChangeListener
    extends DirectoryListenerAdapter {
        private ConsumerLogEntryChangeListener() {
        }

        private ReplicaEventLog getEventLog(OperationContext opCtx) {
            Dn consumerLogDn = opCtx.getDn();
            String name = "REPL_EVENT_LOG." + consumerLogDn.getRdn().getValue().getString();
            for (ReplicaEventLog log : SyncReplRequestHandler.this.replicaLogMap.values()) {
                if (!name.equalsIgnoreCase(log.getName())) continue;
                return log;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryDeleted(DeleteOperationContext deleteContext) {
            ConsumerLogEntryChangeListener consumerLogEntryChangeListener = this;
            synchronized (consumerLogEntryChangeListener) {
                ReplicaEventLog log = this.getEventLog(deleteContext);
                if (log != null) {
                    SyncReplRequestHandler.this.logJanitor.removeEventLog(log);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryModified(ModifyOperationContext modifyContext) {
            List<Modification> mods = modifyContext.getModItems();
            ConsumerLogEntryChangeListener consumerLogEntryChangeListener = this;
            synchronized (consumerLogEntryChangeListener) {
                for (Modification m : mods) {
                    try {
                        ReplicaEventLog log;
                        Attribute at = m.getAttribute();
                        if (at.isInstanceOf(SyncReplRequestHandler.this.REPL_LOG_MAX_IDLE_AT)) {
                            log = this.getEventLog(modifyContext);
                            if (log == null) continue;
                            int maxIdlePeriod = Integer.parseInt(m.getAttribute().getString());
                            log.setMaxIdlePeriod(maxIdlePeriod);
                            continue;
                        }
                        if (!at.isInstanceOf(SyncReplRequestHandler.this.REPL_LOG_PURGE_THRESHOLD_COUNT_AT) || (log = this.getEventLog(modifyContext)) == null) continue;
                        int purgeThreshold = Integer.parseInt(m.getAttribute().getString());
                        log.setPurgeThresholdCount(purgeThreshold);
                    }
                    catch (LdapInvalidAttributeValueException e) {
                        PROVIDER_LOG.warn("Invalid attribute type", e);
                    }
                }
            }
        }
    }
}

