/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.Serializer;

public class LongSerializer
implements Serializer {
    private static final long serialVersionUID = 237756689544852128L;
    public static final LongSerializer INSTANCE = new LongSerializer();

    @Override
    public byte[] serialize(Object o) throws IOException {
        long id = (Long)o;
        byte[] bites = new byte[]{(byte)(id >> 56), (byte)(id >> 48), (byte)(id >> 40), (byte)(id >> 32), (byte)(id >> 24), (byte)(id >> 16), (byte)(id >> 8), (byte)id};
        return bites;
    }

    @Override
    public Object deserialize(byte[] bites) throws IOException {
        long id = bites[0] + (bites[0] < 0 ? 256 : 0);
        id <<= 8;
        id += (long)(bites[1] + (bites[1] < 0 ? 256 : 0));
        id <<= 8;
        id += (long)(bites[2] + (bites[2] < 0 ? 256 : 0));
        id <<= 8;
        id += (long)(bites[3] + (bites[3] < 0 ? 256 : 0));
        id <<= 8;
        id += (long)(bites[4] + (bites[4] < 0 ? 256 : 0));
        id <<= 8;
        id += (long)(bites[5] + (bites[5] < 0 ? 256 : 0));
        id <<= 8;
        id += (long)(bites[6] + (bites[6] < 0 ? 256 : 0));
        id <<= 8;
        return id += (long)(bites[7] + (bites[7] < 0 ? 256 : 0));
    }
}

