/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.CsnSyntaxChecker;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.GeneralizedTimeSyntaxChecker;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.UuidSyntaxChecker;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.loader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.api.util.exception.Exceptions;
import org.apache.directory.server.config.ConfigPartitionInitializer;
import org.apache.directory.server.config.ConfigPartitionReader;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.HttpServerBean;
import org.apache.directory.server.config.beans.LdapServerBean;
import org.apache.directory.server.config.beans.NtpServerBean;
import org.apache.directory.server.config.builder.ServiceBuilder;
import org.apache.directory.server.config.listener.ConfigChangeListener;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.shared.DefaultDnFactory;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.integration.http.HttpServer;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ntp.NtpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDsService {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDsService.class);
    private LdapServer ldapServer;
    private NtpServer ntpServer;
    private KdcServer kdcServer;
    private HttpServer httpServer;
    private LdifPartition schemaLdifPartition;
    private SchemaManager schemaManager;
    private LdifPartition configPartition;
    private ConfigPartitionReader cpReader;
    private UuidSyntaxChecker uuidChecker = new UuidSyntaxChecker();
    private CsnSyntaxChecker csnChecker = new CsnSyntaxChecker();
    private GeneralizedTimeSyntaxChecker timeChecker = new GeneralizedTimeSyntaxChecker();
    private static final Map<String, AttributeTypeOptions> MANDATORY_ENTRY_ATOP_MAP = new HashMap<String, AttributeTypeOptions>();
    private static String[] MANDATORY_ENTRY_ATOP_AT;
    private boolean isSchemaPartitionFirstExtraction = false;
    private static final String BANNER_LDAP = "           _                     _          ____  ____   \n          / \\   _ __    ___  ___| |__   ___|  _ \\/ ___|  \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\  \n        / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) | \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/  \n               |_|                                       \n";
    private static final String BANNER_NTP = "           _                     _          _   _ _____ _ __    \n          / \\   _ __    ___  ___| |__   ___| \\ | |_  __| '_ \\   \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ .\\| | | | | |_) |  \n        / ___ \\| |_) | (_| | (__| | | |  __/ |\\  | | | | .__/   \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|_| \\_| |_| |_|      \n               |_|                                              \n";
    private static final String BANNER_KERBEROS = "           _                     _          _  __ ____   ___    \n          / \\   _ __    ___  ___| |__   ___| |/ /|  _ \\ / __|   \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ ' / | | | / /      \n        / ___ \\| |_) | (_| | (__| | | |  __/ . \\ | |_| \\ \\__    \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|_|\\_\\|____/ \\___|   \n               |_|                                              \n";
    private static final String BANNER_CHANGE_PWD = "         ___                              ___ __  __ __  ______    \n        / __|_       ___ _ __   ____  ___|  _ \\ \\ \\ / / / |  _ \\   \n       / /  | |__  / _` | '  \\ / ___\\/ _ \\ |_) \\ \\ / /\\/ /| | | |  \n       \\ \\__| '_  \\ (_| | |\\  | |___ | __/  __/ \\ ' /   / | |_| |  \n        \\___|_| |_|\\__,_|_| |_|\\__. |\\___| |     \\_/ \\_/  |____/   \n                                  |_|    |_|                       \n";

    public void start(InstanceLayout instanceLayout) throws Exception {
        File partitionsDir = instanceLayout.getPartitionsDirectory();
        if (!partitionsDir.exists()) {
            LOG.info("partition directory doesn't exist, creating {}", (Object)partitionsDir.getAbsolutePath());
            if (!partitionsDir.mkdirs()) {
                throw new IOException(I18n.err(I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, partitionsDir));
            }
        }
        LOG.info("using partition dir {}", (Object)partitionsDir.getAbsolutePath());
        CacheService cacheService = new CacheService();
        cacheService.initialize(instanceLayout);
        this.initSchemaManager(instanceLayout);
        DefaultDnFactory dnFactory = new DefaultDnFactory(this.schemaManager, cacheService.getCache("dnCache"));
        this.initSchemaLdifPartition(instanceLayout, dnFactory);
        this.initConfigPartition(instanceLayout, dnFactory, cacheService);
        this.cpReader = new ConfigPartitionReader(this.configPartition);
        ConfigBean configBean = this.cpReader.readConfig();
        DirectoryServiceBean directoryServiceBean = configBean.getDirectoryServiceBean();
        DirectoryService directoryService = this.initDirectoryService(instanceLayout, directoryServiceBean, cacheService, dnFactory);
        this.startLdap(directoryServiceBean.getLdapServerBean(), directoryService);
        this.startNtp(directoryServiceBean.getNtpServerBean(), directoryService);
        this.startKerberos(directoryServiceBean, directoryService);
        this.startHttpServer(directoryServiceBean.getHttpServerBean(), directoryService);
        LOG.info("Registering config change listener");
        ConfigChangeListener configListener = new ConfigChangeListener(this.cpReader, directoryService);
        NotificationCriteria criteria = new NotificationCriteria();
        criteria.setBase(this.configPartition.getSuffixDn());
        criteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
        PresenceNode filter = new PresenceNode("objectClass");
        criteria.setFilter(filter);
        criteria.setScope(SearchScope.SUBTREE);
        directoryService.getEventService().addListener(configListener, criteria);
    }

    private void initSchemaManager(InstanceLayout instanceLayout) throws Exception {
        File schemaPartitionDirectory = new File(instanceLayout.getPartitionsDirectory(), "schema");
        if (schemaPartitionDirectory.exists()) {
            LOG.info("schema partition already exists, skipping schema extraction");
        } else {
            DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(instanceLayout.getPartitionsDirectory());
            extractor.extractOrCopy();
            this.isSchemaPartitionFirstExtraction = true;
        }
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaPartitionDirectory);
        this.schemaManager = new DefaultSchemaManager(loader);
        this.schemaManager.loadAllEnabled();
        List<Throwable> errors = this.schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err(I18n.ERR_317, Exceptions.printErrors(errors)));
        }
    }

    private void initSchemaLdifPartition(InstanceLayout instanceLayout, DnFactory dnFactory) throws Exception {
        File schemaPartitionDirectory = new File(instanceLayout.getPartitionsDirectory(), "schema");
        this.schemaLdifPartition = new LdifPartition(this.schemaManager, dnFactory);
        this.schemaLdifPartition.setPartitionPath(schemaPartitionDirectory.toURI());
    }

    private void initConfigPartition(InstanceLayout instanceLayout, DnFactory dnFactory, CacheService cacheService) throws Exception {
        ConfigPartitionInitializer initializer = new ConfigPartitionInitializer(instanceLayout, dnFactory, cacheService, this.schemaManager);
        this.configPartition = initializer.initConfigPartition();
    }

    private DirectoryService initDirectoryService(InstanceLayout instanceLayout, DirectoryServiceBean directoryServiceBean, CacheService cacheService, DnFactory dnFactory) throws Exception {
        LOG.info("Initializing the DirectoryService...");
        long startTime = System.currentTimeMillis();
        DirectoryService directoryService = ServiceBuilder.createDirectoryService(directoryServiceBean, instanceLayout, this.schemaManager);
        directoryService.setDnFactory(dnFactory);
        SchemaPartition schemaPartition = new SchemaPartition(this.schemaManager);
        schemaPartition.setWrappedPartition(this.schemaLdifPartition);
        directoryService.setSchemaPartition(schemaPartition);
        directoryService.addPartition(this.configPartition);
        directoryService.setInstanceLayout(instanceLayout);
        directoryService.setCacheService(cacheService);
        directoryService.startup();
        AttributeType ocAt = this.schemaManager.lookupAttributeTypeRegistry("objectClass");
        MANDATORY_ENTRY_ATOP_MAP.put(ocAt.getName(), new AttributeTypeOptions(ocAt));
        AttributeType uuidAt = this.schemaManager.lookupAttributeTypeRegistry("entryUUID");
        MANDATORY_ENTRY_ATOP_MAP.put(uuidAt.getName(), new AttributeTypeOptions(uuidAt));
        AttributeType csnAt = this.schemaManager.lookupAttributeTypeRegistry("entryCSN");
        MANDATORY_ENTRY_ATOP_MAP.put(csnAt.getName(), new AttributeTypeOptions(csnAt));
        AttributeType creatorAt = this.schemaManager.lookupAttributeTypeRegistry("creatorsName");
        MANDATORY_ENTRY_ATOP_MAP.put(creatorAt.getName(), new AttributeTypeOptions(creatorAt));
        AttributeType createdTimeAt = this.schemaManager.lookupAttributeTypeRegistry("createTimestamp");
        MANDATORY_ENTRY_ATOP_MAP.put(createdTimeAt.getName(), new AttributeTypeOptions(createdTimeAt));
        MANDATORY_ENTRY_ATOP_AT = new String[MANDATORY_ENTRY_ATOP_MAP.size()];
        int pos = 0;
        for (AttributeTypeOptions attributeTypeOptions : MANDATORY_ENTRY_ATOP_MAP.values()) {
            ApacheDsService.MANDATORY_ENTRY_ATOP_AT[pos++] = attributeTypeOptions.getAttributeType().getName();
        }
        if (this.isSchemaPartitionFirstExtraction) {
            LOG.info("begining to update schema partition LDIF files after modifying manadatory attributes");
            this.updateMandatoryOpAttributes(this.schemaLdifPartition, directoryService);
            LOG.info("schema partition data was successfully updated");
        }
        LOG.info("DirectoryService initialized in {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
        return directoryService;
    }

    private void startLdap(LdapServerBean ldapServerBean, DirectoryService directoryService) throws Exception {
        LOG.info("Starting the LDAP server");
        long startTime = System.currentTimeMillis();
        this.ldapServer = ServiceBuilder.createLdapServer(ldapServerBean, directoryService);
        if (this.ldapServer == null) {
            LOG.info("Cannot find any reference to the LDAP Server in the configuration : the server won't be started");
            return;
        }
        ApacheDsService.printBanner(BANNER_LDAP);
        this.ldapServer.start();
        LOG.info("LDAP server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
    }

    private void startNtp(NtpServerBean ntpServerBean, DirectoryService directoryService) throws Exception {
        LOG.info("Starting the NTP server");
        long startTime = System.currentTimeMillis();
        this.ntpServer = ServiceBuilder.createNtpServer(ntpServerBean, directoryService);
        if (this.ntpServer == null) {
            LOG.info("Cannot find any reference to the NTP Server in the configuration : the server won't be started");
            return;
        }
        ApacheDsService.printBanner(BANNER_NTP);
        this.ntpServer.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("NTP server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void startKerberos(DirectoryServiceBean directoryServiceBean, DirectoryService directoryService) throws Exception {
        LOG.info("Starting the Kerberos server");
        long startTime = System.currentTimeMillis();
        this.kdcServer = ServiceBuilder.createKdcServer(directoryServiceBean, directoryService);
        if (this.kdcServer == null) {
            LOG.info("Cannot find any reference to the Kerberos Server in the configuration : the server won't be started");
            return;
        }
        LOG.info("Starting the Kerberos server");
        this.getDirectoryService().startup();
        this.kdcServer.setDirectoryService(this.getDirectoryService());
        ApacheDsService.printBanner(BANNER_KERBEROS);
        this.kdcServer.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("Kerberos server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void startHttpServer(HttpServerBean httpServerBean, DirectoryService directoryService) throws Exception {
        this.httpServer = ServiceBuilder.createHttpServer(httpServerBean, directoryService);
        if (this.httpServer == null) {
            LOG.info("Cannot find any reference to the HTTP Server in the configuration : the server won't be started");
            return;
        }
        LOG.info("Starting the Http server");
        long startTime = System.currentTimeMillis();
        this.httpServer.start(this.getDirectoryService());
        if (LOG.isInfoEnabled()) {
            LOG.info("Http server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    public DirectoryService getDirectoryService() {
        return this.ldapServer.getDirectoryService();
    }

    public void synch() throws Exception {
        this.ldapServer.getDirectoryService().sync();
    }

    public void stop() throws Exception {
        if (this.ldapServer != null) {
            this.ldapServer.stop();
        }
        if (this.kdcServer != null) {
            this.kdcServer.stop();
        }
        if (this.ntpServer != null) {
            this.ntpServer.stop();
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        this.ldapServer.getDirectoryService().shutdown();
    }

    public static void printBanner(String bannerConstant) {
        System.out.println(bannerConstant);
    }

    public void updateMandatoryOpAttributes(Partition partition, DirectoryService dirService) throws Exception {
        CoreSession session = dirService.getAdminSession();
        String adminDn = session.getEffectivePrincipal().getName();
        PresenceNode filter = new PresenceNode("objectClass");
        Cursor<Entry> cursor = session.search(partition.getSuffixDn(), SearchScope.SUBTREE, filter, AliasDerefMode.NEVER_DEREF_ALIASES, MANDATORY_ENTRY_ATOP_AT);
        cursor.beforeFirst();
        ArrayList<Modification> mods = new ArrayList<Modification>();
        while (cursor.next()) {
            String createdTime;
            String creator;
            String csn;
            String uuid;
            AttributeType atType;
            Entry entry = cursor.get();
            Attribute uuidAt = entry.get(atType = MANDATORY_ENTRY_ATOP_MAP.get("entryUUID").getAttributeType());
            String string = uuid = uuidAt == null ? null : uuidAt.getString();
            if (!this.uuidChecker.isValidSyntax(uuid)) {
                uuidAt = new DefaultAttribute(atType, UUID.randomUUID().toString());
            }
            DefaultModification uuidMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, uuidAt);
            mods.add(uuidMod);
            atType = MANDATORY_ENTRY_ATOP_MAP.get("entryCSN").getAttributeType();
            Attribute csnAt = entry.get(atType);
            String string2 = csn = csnAt == null ? null : csnAt.getString();
            if (!this.csnChecker.isValidSyntax(csn)) {
                csnAt = new DefaultAttribute(atType, dirService.getCSN().toString());
            }
            DefaultModification csnMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, csnAt);
            mods.add(csnMod);
            atType = MANDATORY_ENTRY_ATOP_MAP.get("creatorsName").getAttributeType();
            Attribute creatorAt = entry.get(atType);
            String string3 = creator = creatorAt == null ? "" : creatorAt.getString().trim();
            if (creator.length() == 0 || !Dn.isValid(creator)) {
                creatorAt = new DefaultAttribute(atType, adminDn);
            }
            DefaultModification creatorMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, creatorAt);
            mods.add(creatorMod);
            atType = MANDATORY_ENTRY_ATOP_MAP.get("createTimestamp").getAttributeType();
            Attribute createdTimeAt = entry.get(atType);
            String string4 = createdTime = createdTimeAt == null ? null : createdTimeAt.getString();
            if (!this.timeChecker.isValidSyntax(createdTime)) {
                createdTimeAt = new DefaultAttribute(atType, DateUtils.getGeneralizedTime());
            }
            DefaultModification createdMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, createdTimeAt);
            mods.add(createdMod);
            if (!mods.isEmpty()) {
                LOG.debug("modifying the entry {} after adding missing manadatory operational attributes", (Object)entry.getDn());
                ModifyOperationContext modifyContext = new ModifyOperationContext(session);
                modifyContext.setEntry(entry);
                modifyContext.setDn(entry.getDn());
                modifyContext.setModItems(mods);
                partition.modify(modifyContext);
            }
            mods.clear();
        }
        cursor.close();
    }
}

