/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import java.util.Arrays;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;

public class PagedResultsImpl
extends AbstractControl
implements PagedResults {
    private int size;
    private byte[] cookie = StringConstants.EMPTY_BYTES;

    public PagedResultsImpl() {
        super("1.2.840.113556.1.4.319");
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    @Override
    public int getCookieValue() {
        int value = 0;
        switch (this.cookie.length) {
            case 1: {
                value = this.cookie[0] & 0xFF;
                break;
            }
            case 2: {
                value = ((this.cookie[0] & 0xFF) << 8) + (this.cookie[1] & 0xFF);
                break;
            }
            case 3: {
                value = ((this.cookie[0] & 0xFF) << 16) + ((this.cookie[1] & 0xFF) << 8) + (this.cookie[2] & 0xFF);
                break;
            }
            case 4: {
                value = ((this.cookie[0] & 0xFF) << 24) + ((this.cookie[1] & 0xFF) << 16) + ((this.cookie[2] & 0xFF) << 8) + (this.cookie[3] & 0xFF);
            }
        }
        return value;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 37 + this.size;
        if (this.cookie != null) {
            for (byte b : this.cookie) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        PagedResults otherControl = (PagedResults)o;
        return this.size == otherControl.getSize() && Arrays.equals(this.cookie, otherControl.getCookie());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Paged Search Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        size   : '").append(this.size).append("'\n");
        sb.append("        cookie   : '").append(Strings.dumpBytes(this.cookie)).append("'\n");
        return sb.toString();
    }
}

