/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import org.apache.directory.server.ApacheDsService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UberjarMain {
    private static final Logger LOG = LoggerFactory.getLogger(UberjarMain.class);
    private ApacheDsService service;

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 1) {
            throw new IllegalArgumentException("Program must be launched with 1 arguement, the path to the instance directory.");
        }
        UberjarMain uberjarMain = new UberjarMain();
        uberjarMain.start(args);
    }

    public void start(String[] args) {
        this.service = new ApacheDsService();
        InstanceLayout instanceLayout = new InstanceLayout(args[0]);
        try {
            this.service.start(instanceLayout);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Failed to start the service.", e);
            System.exit(1);
        }
    }

    public void stop() {
        if (this.service != null) {
            try {
                this.service.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("Failed to start the service.", e);
                System.exit(1);
            }
        }
    }
}

